/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.explosion;

import java.util.ArrayList;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.TntBehavior;
import net.mehvahdjukaar.supplementaries.reg.ModFluids;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class GunpowderExplosion
extends Explosion {
    private static final Holder<SoundEvent> EMPTY_SOUND = BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.EMPTY);

    public static void explode(ServerLevel world, BlockPos pos) {
        Vec3 center = Vec3.atCenterOf((Vec3i)pos);
        GunpowderExplosion explosion = new GunpowderExplosion((Level)world, center.x, center.y, center.z);
        if (ForgeHelper.fireOnExplosionStart((Level)world, (Explosion)explosion)) {
            return;
        }
        explosion.explode();
        explosion.finalizeExplosion(false);
        if (!explosion.interactsWithBlocks()) {
            explosion.clearToBlow();
        }
        for (ServerPlayer serverPlayer : world.players()) {
            if (!(serverPlayer.distanceToSqr(center) < 4096.0)) continue;
            serverPlayer.connection.send((Packet)new ClientboundExplodePacket(center.x, center.y, center.z, explosion.radius(), explosion.getToBlow(), (Vec3)explosion.getHitPlayers().get(serverPlayer), explosion.getBlockInteraction(), explosion.getSmallExplosionParticles(), explosion.getLargeExplosionParticles(), explosion.getExplosionSound()));
        }
    }

    public GunpowderExplosion(Level world, double x, double y, double z) {
        super(world, null, null, null, x, y, z, 0.5f, false, Explosion.BlockInteraction.DESTROY, (ParticleOptions)ParticleTypes.ASH, (ParticleOptions)ParticleTypes.ASH, EMPTY_SOUND);
    }

    public void explode() {
        int px = Mth.floor((double)this.x);
        int py = Mth.floor((double)this.y);
        int pz = Mth.floor((double)this.z);
        ForgeHelper.fireOnExplosionDetonate((Level)this.level, (Explosion)this, new ArrayList(), (double)(this.radius * 2.0f));
        this.explodeSingleBlock(px + 1, py, pz);
        this.explodeSingleBlock(px - 1, py, pz);
        this.explodeSingleBlock(px, py + 1, pz);
        this.explodeSingleBlock(px, py - 1, pz);
        this.explodeSingleBlock(px, py, pz + 1);
        this.explodeSingleBlock(px, py, pz - 1);
        this.explodeSingleBlock(px, py + 1, pz + 1);
        this.explodeSingleBlock(px, py + 1, pz - 1);
        this.explodeSingleBlock(px + 1, py + 1, pz);
        this.explodeSingleBlock(px - 1, py + 1, pz);
        BlockPos myPos = new BlockPos(px, py, pz);
        BlockState newFire = BaseFireBlock.getState((BlockGetter)this.level, (BlockPos)myPos);
        BlockState s = this.level.getBlockState(myPos);
        if (s.canBeReplaced() && this.level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK) && (this.hasFlammableNeighbours(myPos) || newFire.getBlock() != Blocks.FIRE)) {
            this.level.setBlockAndUpdate(myPos, newFire);
        }
    }

    private boolean hasFlammableNeighbours(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockState state = this.level.getBlockState(pos.relative(direction));
            if (!PlatHelper.isFireSource((BlockState)state, (Level)this.level, (BlockPos)pos, (Direction)direction.getOpposite()) && !PlatHelper.isFlammable((BlockState)state, (BlockGetter)this.level, (BlockPos)pos, (Direction)direction.getOpposite())) continue;
            return true;
        }
        return false;
    }

    private void explodeSingleBlock(int i, int j, int k) {
        BlockPos pos = new BlockPos(i, j, k);
        FluidState fluidstate = this.level.getFluidState(pos);
        if (fluidstate.getType() == Fluids.EMPTY || fluidstate.getType() == ModFluids.LUMISENE_FLUID.get()) {
            BlockState state = this.level.getBlockState(pos);
            Block block = state.getBlock();
            if (ForgeHelper.getExplosionResistance((BlockState)state, (Level)this.level, (BlockPos)pos, (Explosion)this) == 0.0f) {
                if (state.getBlock() instanceof TntBlock) {
                    this.getToBlow().add(pos);
                } else if (TntBehavior.isTNTLikeBlock(state)) {
                    TntBehavior.igniteTntHack(state, this.level, pos);
                }
            }
            if (block instanceof ILightable) {
                ILightable iLightable = (ILightable)block;
                iLightable.tryLightUp(null, state, pos, (LevelAccessor)this.level, ILightable.FireSoundType.FLAMING_ARROW);
            } else if (GunpowderExplosion.canLight(state)) {
                this.level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.TRUE), 11);
                ILightable.FireSoundType.FLAMING_ARROW.play((LevelAccessor)this.level, pos);
            }
        }
    }

    private static boolean canLight(BlockState state) {
        Block b = state.getBlock();
        if (b instanceof AbstractCandleBlock) {
            return !AbstractCandleBlock.isLit((BlockState)state);
        }
        if (state.hasProperty((Property)BlockStateProperties.LIT) && state.is(ModTags.LIGHTABLE_BY_GUNPOWDER)) {
            return (Boolean)state.getValue((Property)BlockStateProperties.LIT) == false && (!state.hasProperty((Property)BlockStateProperties.WATERLOGGED) || (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) == false);
        }
        return false;
    }
}

