/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.map_data;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.MapDataRegistry;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.ColoredMapHandler;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.DepthDataHandler;
import net.mehvahdjukaar.supplementaries.common.misc.map_data.MapLightHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class WeatheredHandler {
    private static final String ANTIQUE_KEY = "antique";
    private static final CustomMapData.Type<Boolean, WeatheredMapData> ANTIQUE_DATA_KEY;
    public static final MapColor ANTIQUE_LIGHT;
    public static final MapColor ANTIQUE_DARK;
    private static final Object2ObjectArrayMap<MapColor, MapColor> ANTIQUE_COLORS;

    public static void init() {
    }

    public static WeatheredMapData getAntiqueData(MapItemSavedData data) {
        return (WeatheredMapData)ANTIQUE_DATA_KEY.get(data);
    }

    public static void setAntique(Level level, ItemStack stack, boolean on) {
        WeatheredHandler.setAntique(level, stack, on, false);
    }

    public static void setAntique(Level level, ItemStack stack, boolean on, boolean replaceOld) {
        MapItemSavedData mapitemsaveddata = MapItem.getSavedData((ItemStack)stack, (Level)level);
        MapId mapId = WeatheredHandler.createAntiqueMapData(mapitemsaveddata, level, on, replaceOld);
        if (mapId != null) {
            stack.set(DataComponents.MAP_ID, (Object)mapId);
        }
    }

    public static MapId createAntiqueMapData(MapItemSavedData mapitemsaveddata, Level level, boolean on, boolean replaceOld) {
        if (mapitemsaveddata instanceof ExpandedMapData) {
            ExpandedMapData data = (ExpandedMapData)mapitemsaveddata;
            MapItemSavedData newData = replaceOld ? mapitemsaveddata : data.ml$copy();
            WeatheredMapData instance = WeatheredHandler.getAntiqueData(newData);
            ColoredMapHandler.ColorData colorData = ColoredMapHandler.getColorData(newData);
            colorData.clear();
            MapLightHandler.LightData lightData = MapLightHandler.getLightData(newData);
            lightData.clear();
            instance.set(on);
            instance.setDirty(newData, CustomMapData.SimpleDirtyCounter::markDirty);
            if (!replaceOld) {
                MapId mapId = level.getFreeMapId();
                level.setMapData(mapId, newData);
                return mapId;
            }
        }
        return null;
    }

    static {
        MapColor mc1;
        MapColor mc;
        ANTIQUE_DATA_KEY = MapDataRegistry.registerCustomMapSavedData((ResourceLocation)Supplementaries.res(ANTIQUE_KEY), WeatheredMapData::new, (StreamCodec)ByteBufCodecs.BOOL);
        ANTIQUE_COLORS = new Object2ObjectArrayMap();
        try {
            Class<MapColor> cl = MapColor.class;
            Constructor cons = cl.getDeclaredConstructor(Integer.TYPE, Integer.TYPE);
            cons.setAccessible(true);
            mc = (MapColor)cons.newInstance(62, 13870193);
            mc1 = (MapColor)cons.newInstance(63, 10976850);
        }
        catch (Exception e) {
            mc = MapColor.TERRACOTTA_WHITE;
            mc1 = MapColor.RAW_IRON;
            Supplementaries.LOGGER.warn("Failed to add custom map colors for antique map: ", (Throwable)e);
        }
        ANTIQUE_DARK = mc1;
        ANTIQUE_LIGHT = mc;
        ANTIQUE_COLORS.put((Object)MapColor.STONE, (Object)MapColor.DIRT);
        ANTIQUE_COLORS.put((Object)MapColor.DEEPSLATE, (Object)MapColor.DIRT);
        ANTIQUE_COLORS.put((Object)MapColor.PLANT, (Object)MapColor.COLOR_BROWN);
        ANTIQUE_COLORS.put((Object)MapColor.DIRT, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.WOOD, (Object)MapColor.WOOD);
        ANTIQUE_COLORS.put((Object)MapColor.COLOR_GRAY, (Object)MapColor.COLOR_BROWN);
        ANTIQUE_COLORS.put((Object)MapColor.TERRACOTTA_BLACK, (Object)MapColor.TERRACOTTA_BLACK);
        ANTIQUE_COLORS.put((Object)MapColor.COLOR_BLACK, (Object)MapColor.TERRACOTTA_BLACK);
        ANTIQUE_COLORS.put((Object)MapColor.SAND, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.QUARTZ, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.SNOW, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.METAL, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.WOOL, (Object)ANTIQUE_LIGHT);
        ANTIQUE_COLORS.put((Object)MapColor.COLOR_BROWN, (Object)MapColor.TERRACOTTA_BROWN);
    }

    public static class WeatheredMapData
    extends CustomMapData.Simple<Boolean> {
        public WeatheredMapData() {
            super((Object)false);
        }

        public boolean isAntique() {
            return (Boolean)this.value;
        }

        public void load(CompoundTag tag, HolderLookup.Provider registries) {
            this.value = tag.contains(WeatheredHandler.ANTIQUE_KEY) ? Boolean.valueOf(tag.getBoolean(WeatheredHandler.ANTIQUE_KEY)) : Boolean.valueOf(false);
        }

        public void save(CompoundTag tag, HolderLookup.Provider lookup) {
            if (((Boolean)this.value).booleanValue()) {
                tag.putBoolean(WeatheredHandler.ANTIQUE_KEY, true);
            }
        }

        public CustomMapData.Type<Boolean, WeatheredMapData> getType() {
            return ANTIQUE_DATA_KEY;
        }

        @Nullable
        public Component onItemTooltip(MapItemSavedData data, ItemStack stack) {
            if (((Boolean)this.value).booleanValue()) {
                return Component.translatable((String)"filled_map.antique.tooltip").withStyle(ChatFormatting.GRAY);
            }
            return null;
        }

        public CustomMapData.SimpleDirtyCounter createDirtyCounter() {
            return new CustomMapData.SimpleDirtyCounter();
        }

        public boolean onItemUpdate(MapItemSavedData data, Entity entity) {
            boolean hasCeiling;
            if (!((Boolean)this.value).booleanValue()) {
                return false;
            }
            Level level = entity.level();
            if (level.dimension() != data.dimension || !(entity instanceof Player)) {
                return true;
            }
            Player pl = (Player)entity;
            Optional<Integer> minHeight = DepthDataHandler.getMapHeight(data);
            int minHeightOrTop = minHeight.orElse(Integer.MAX_VALUE);
            boolean hasDepthLock = minHeight.isPresent();
            if (hasDepthLock && !DepthDataHandler.canPlayerSee(minHeight.get(), (Entity)pl)) {
                return true;
            }
            int scale = 1 << data.scale;
            int mapX = data.centerX;
            int mapZ = data.centerZ;
            int playerX = Mth.floor((double)(entity.getX() - (double)mapX)) / scale + 64;
            int playerZ = Mth.floor((double)(entity.getZ() - (double)mapZ)) / scale + 64;
            int range = 128 / scale;
            if (hasDepthLock) {
                range = (int)((double)range * DepthDataHandler.getRangeMultiplier());
            }
            if (hasCeiling = WeatheredMapData.isHasCeiling(level, minHeight)) {
                range /= 2;
            }
            MapItemSavedData.HoldingPlayer player = data.getHoldingPlayer((Player)entity);
            boolean hasChangedAColorThisZ = false;
            for (int pixelX = playerX - range + 1; pixelX < playerX + range; ++pixelX) {
                if ((pixelX & 0xF) != (player.step & 0xF) && !hasChangedAColorThisZ) continue;
                hasChangedAColorThisZ = false;
                double somethingY = 0.0;
                for (int pixelZ = playerZ - range - 1; pixelZ < playerZ + range; ++pixelZ) {
                    LevelChunk lc;
                    boolean maxRadius;
                    if (pixelX < 0 || pixelZ < -1 || pixelX >= 128 || pixelZ >= 128) continue;
                    int offsetX = pixelX - playerX;
                    int offsetZ = pixelZ - playerZ;
                    int dist = offsetX * offsetX + offsetZ * offsetZ;
                    boolean bl = maxRadius = dist > range * range;
                    if (maxRadius) continue;
                    boolean innerRadius = dist > (range - 2) * (range - 2);
                    int worldX = (mapX / scale + pixelX - 64) * scale;
                    int worldZ = (mapZ / scale + pixelZ - 64) * scale;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    ChunkAccess levelchunk = level.getChunk(SectionPos.blockToSectionCoord((int)worldX), SectionPos.blockToSectionCoord((int)worldZ), ChunkStatus.FULL, false);
                    if (!(levelchunk instanceof LevelChunk) || (lc = (LevelChunk)levelchunk).isEmpty()) continue;
                    ChunkPos chunkpos = levelchunk.getPos();
                    int chunkCoordX = worldX & 0xF;
                    int chunkCoordZ = worldZ & 0xF;
                    double maxY = 0.0;
                    int distanceFromLand = 8;
                    HashMap<BlockPos, Boolean> isWaterMap = new HashMap<BlockPos, Boolean>();
                    if (hasCeiling) {
                        int l3 = worldX + worldZ * 231871;
                        if (((l3 = l3 * l3 * 31287121 + l3 * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.DIRT.defaultBlockState().getMapColor((BlockGetter)level, BlockPos.ZERO), 10);
                        } else {
                            multiset.add((Object)Blocks.BROWN_WOOL.defaultBlockState().getMapColor((BlockGetter)level, BlockPos.ZERO), 100);
                        }
                        maxY = 100.0;
                        distanceFromLand = 0;
                    } else {
                        BlockPos.MutableBlockPos mutable1 = new BlockPos.MutableBlockPos();
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ - scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX - scale, worldZ + scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ - scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX + scale, worldZ + scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX, worldZ - scale)) {
                            --distanceFromLand;
                        }
                        if (WeatheredMapData.isWaterAt(level, isWaterMap, scale, worldX, worldZ + scale)) {
                            --distanceFromLand;
                        }
                        for (int scaleOffsetX = 0; scaleOffsetX < scale; ++scaleOffsetX) {
                            for (int scaleOffsetZ = 0; scaleOffsetZ < scale; ++scaleOffsetZ) {
                                int cY = Math.min(minHeightOrTop, levelchunk.getHeight(Heightmap.Types.WORLD_SURFACE, scaleOffsetX + chunkCoordX, scaleOffsetZ + chunkCoordZ) + 1);
                                MapColor newColor = null;
                                if (cY <= level.getMinBuildHeight() + 1) {
                                    newColor = Blocks.BEDROCK.defaultBlockState().getMapColor((BlockGetter)level, (BlockPos)mutable1);
                                } else {
                                    BlockState blockState;
                                    MapColor temp;
                                    do {
                                        mutable1.set(chunkpos.getMinBlockX() + scaleOffsetX + chunkCoordX, --cY, chunkpos.getMinBlockZ() + scaleOffsetZ + chunkCoordZ);
                                        blockState = levelchunk.getBlockState((BlockPos)mutable1);
                                        temp = blockState.getMapColor((BlockGetter)level, (BlockPos)mutable1);
                                        if (temp == MapColor.NONE || temp == MapColor.WATER || !blockState.getCollisionShape((BlockGetter)level, (BlockPos)mutable1).isEmpty()) continue;
                                        newColor = MapColor.GRASS;
                                    } while (temp == MapColor.NONE && cY > level.getMinBuildHeight());
                                    if (newColor == null) {
                                        newColor = blockState.getMapColor((BlockGetter)level, (BlockPos)mutable1);
                                    }
                                }
                                data.checkBanners((BlockGetter)level, chunkpos.getMinBlockX() + scaleOffsetX + chunkCoordX, chunkpos.getMinBlockZ() + scaleOffsetZ + chunkCoordZ);
                                maxY += (double)cY / (double)(scale * scale);
                                if (cY >= minHeightOrTop) {
                                    newColor = DepthDataHandler.getCutoffColor((BlockPos)mutable1, (BlockGetter)levelchunk);
                                }
                                multiset.add((Object)newColor);
                            }
                        }
                    }
                    int relativeShade = 1;
                    MapColor mc = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MapColor.NONE);
                    if (mc == MapColor.WATER) {
                        mc = MapColor.COLOR_ORANGE;
                        if (distanceFromLand > 7 && pixelZ % 2 == 0) {
                            relativeShade = (pixelX + (int)(Mth.sin((float)((float)pixelZ + 0.0f)) * 7.0f)) / 8 % 5;
                            if (relativeShade == 3) {
                                relativeShade = 1;
                            } else if (relativeShade == 4) {
                                relativeShade = 0;
                            }
                        } else if (distanceFromLand > 7) {
                            mc = ANTIQUE_LIGHT;
                            relativeShade = 2;
                        } else if (distanceFromLand > 5) {
                            relativeShade = 1;
                        } else if (distanceFromLand > 3) {
                            relativeShade = 0;
                        }
                    } else if (distanceFromLand > 0) {
                        relativeShade = 3;
                        mc = MapColor.COLOR_BROWN;
                        if (distanceFromLand > 3) {
                            relativeShade = 1;
                        }
                    } else {
                        double depthY = (maxY - somethingY) * 4.0 / (double)(scale + 4) + ((double)(pixelX + pixelZ & 1) - 0.5) * 0.4;
                        if (depthY > 0.6) {
                            relativeShade = 2;
                        } else if (depthY < -0.6) {
                            relativeShade = 0;
                        }
                        mc = (MapColor)ANTIQUE_COLORS.getOrDefault((Object)mc, (Object)ANTIQUE_DARK);
                    }
                    somethingY = maxY;
                    if (pixelZ < 0 || innerRadius && (pixelX + pixelZ & 1) == 0) continue;
                    hasChangedAColorThisZ |= data.updateColor(pixelX, pixelZ, (byte)(mc.id * 4 + relativeShade));
                }
            }
            ++player.step;
            return true;
        }

        private static boolean isHasCeiling(Level level, Optional<Integer> mapHeight) {
            boolean original = level.dimensionType().hasCeiling();
            if (original && mapHeight.isPresent() && CommonConfigs.Tools.SLICE_MAP_ENABLED.get().booleanValue()) {
                return false;
            }
            return original;
        }

        public void set(boolean on) {
            this.value = on;
        }

        private static boolean isWaterAt(Level level, Map<BlockPos, Boolean> map, int scale, int x, int z) {
            BlockPos pos = new BlockPos(x, 0, z);
            return map.computeIfAbsent(pos, p -> {
                int y = level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z) - 1;
                return level.getFluidState(pos.above(y)).isEmpty();
            });
        }
    }
}

