/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class BasaltAshFeature
extends Feature<Config> {
    public BasaltAshFeature() {
        super(Config.CODEC);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        Config config = (Config)context.config();
        int xzSpread = config.xzSpread + 1;
        int ySpread = config.ySpread;
        int tries = config.tries;
        RuleTest test = config.target;
        BlockStateProvider ash = config.ash;
        Optional<BlockState> belowAsh = config.belowAsh;
        RandomSource randomSource = context.random();
        BlockPos blockPos = context.origin();
        WorldGenLevel worldGenLevel = context.level();
        int placed = 0;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int l = 0; l < tries; ++l) {
            mutableBlockPos.setWithOffset((Vec3i)blockPos, randomSource.nextInt(xzSpread) - randomSource.nextInt(xzSpread), 0, randomSource.nextInt(xzSpread) - randomSource.nextInt(xzSpread));
            if (!this.placeAsh(worldGenLevel, ySpread, (BlockPos)mutableBlockPos, test, ash, belowAsh, randomSource)) continue;
            ++placed;
        }
        return placed > 0;
    }

    public boolean placeAsh(WorldGenLevel worldGenLevel, int ySpread, BlockPos origin, RuleTest basaltTest, BlockStateProvider ash, Optional<BlockState> belowAsh, RandomSource random) {
        BlockPos.MutableBlockPos pos = origin.mutable();
        int inY = pos.getY();
        boolean success = false;
        int dy = 0;
        BlockState state = worldGenLevel.getBlockState((BlockPos)pos.setY(inY + dy++));
        boolean up = false;
        while (basaltTest.test(state, random) && dy < ySpread) {
            up = true;
            if (!(state = worldGenLevel.getBlockState((BlockPos)pos.setY(inY + dy++))).isAir()) continue;
            success = true;
            --dy;
            break;
        }
        if (!up) {
            while (state.isAir() && dy > -ySpread) {
                if (!basaltTest.test(state = worldGenLevel.getBlockState((BlockPos)pos.setY(inY + dy--)), random)) continue;
                success = true;
                dy += 2;
                break;
            }
        }
        if (success) {
            pos.setY(inY + dy);
            worldGenLevel.setBlock((BlockPos)pos, ash.getState(random, (BlockPos)pos), 2);
            pos.setY(inY + dy - 1);
            belowAsh.ifPresent(blockState -> worldGenLevel.setBlock((BlockPos)pos, blockState, 2));
        }
        return success;
    }

    public record Config(int tries, int xzSpread, int ySpread, RuleTest target, BlockStateProvider ash, Optional<BlockState> belowAsh) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("tries").orElse((Object)64).forGetter(Config::tries), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("xz_spread").orElse((Object)7).forGetter(Config::xzSpread), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("y_spread").orElse((Object)3).forGetter(Config::ySpread), (App)RuleTest.CODEC.fieldOf("target_predicate").forGetter(Config::target), (App)BlockStateProvider.CODEC.fieldOf("top_block").forGetter(Config::ash), (App)BlockState.CODEC.optionalFieldOf("below_block").forGetter(Config::belowAsh)).apply((Applicative)instance, Config::new));
    }
}

