/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModWorldgen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RemoveDisabledBlocksProcessor
extends StructureProcessor {
    public static final RemoveDisabledBlocksProcessor INSTANCE = new RemoveDisabledBlocksProcessor();
    public static final MapCodec<RemoveDisabledBlocksProcessor> CODEC = MapCodec.unit(() -> INSTANCE);
    private static final Map<Block, Replacement> REPLACEMENTS = new HashMap<Block, Replacement>();

    public static void setup() {
        RemoveDisabledBlocksProcessor.add(ModRegistry.CANNON, Blocks.AIR);
        RemoveDisabledBlocksProcessor.add(ModRegistry.URN, Blocks.AIR);
        RemoveDisabledBlocksProcessor.add(ModRegistry.STICK_BLOCK, Blocks.AIR);
        RemoveDisabledBlocksProcessor.add(ModRegistry.GLOBE, Blocks.AIR);
        RemoveDisabledBlocksProcessor.add(ModRegistry.CANNONBALL, Blocks.AIR);
        RemoveDisabledBlocksProcessor.add(ModRegistry.JAR, Blocks.AIR);
        RemoveDisabledBlocksProcessor.add(ModRegistry.ASH_BLOCK, Blocks.AIR);
        RemoveDisabledBlocksProcessor.addAll(ModRegistry.FLAGS.values(), "flag", Blocks.AIR);
        RemoveDisabledBlocksProcessor.add(ModRegistry.SAFE, Blocks.CHEST);
        RemoveDisabledBlocksProcessor.add(ModRegistry.ROPE_KNOT, "rope", Blocks.IRON_BARS);
        RemoveDisabledBlocksProcessor.add(ModRegistry.ROPE, Blocks.IRON_BARS);
        RemoveDisabledBlocksProcessor.addAll(ModRegistry.CANDLE_HOLDERS.values(), "candle_holder", Blocks.TORCH);
        RemoveDisabledBlocksProcessor.add(ModRegistry.GOLD_DOOR, Blocks.DARK_OAK_DOOR);
        RemoveDisabledBlocksProcessor.add(ModRegistry.GOLD_TRAPDOOR, Blocks.DARK_OAK_DOOR);
        RemoveDisabledBlocksProcessor.add(ModRegistry.GOLD_BARS, Blocks.IRON_BARS);
        RemoveDisabledBlocksProcessor.add(ModRegistry.SCONCE, "sconce", Blocks.TORCH);
        RemoveDisabledBlocksProcessor.add(ModRegistry.SCONCE_GREEN, "sconce", Blocks.WALL_TORCH);
        RemoveDisabledBlocksProcessor.add(ModRegistry.SCONCE_SOUL, "sconce", Blocks.SOUL_TORCH);
        RemoveDisabledBlocksProcessor.add(ModRegistry.SCONCE_WALL_SOUL, "sconce", Blocks.SOUL_WALL_TORCH);
        RemoveDisabledBlocksProcessor.add(ModRegistry.SCONCE_LEVER, Blocks.WALL_TORCH);
    }

    private static void add(Block from, Replacement replacement) {
        REPLACEMENTS.put(from, replacement);
    }

    private static void add(Supplier<? extends Block> from, String configKey, Block to) {
        RemoveDisabledBlocksProcessor.add(from.get(), new Replacement(configKey, arg_0 -> ((Block)to).withPropertiesOf(arg_0)));
    }

    private static <A extends Block> void addAll(Iterable<Supplier<A>> fromBlocks, String configKey, Block to) {
        for (Supplier<A> from : fromBlocks) {
            RemoveDisabledBlocksProcessor.add(from, configKey, to);
        }
    }

    private static void add(Supplier<? extends Block> from, Block to) {
        RemoveDisabledBlocksProcessor.add(from, Utils.getID((Block)from.get()).getPath(), to);
    }

    protected StructureProcessorType<?> getType() {
        return ModWorldgen.REMOVE_DISABLED_PROCESSOR.get();
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader level, BlockPos offset, BlockPos pos, StructureTemplate.StructureBlockInfo blockInfo, StructureTemplate.StructureBlockInfo relativeBlockInfo, StructurePlaceSettings settings) {
        BlockState blockState = relativeBlockInfo.state();
        Replacement replacement = REPLACEMENTS.get(blockState.getBlock());
        if (replacement == null || replacement.isEnabled()) {
            return relativeBlockInfo;
        }
        BlockState blockState2 = replacement.transform(blockState);
        return new StructureTemplate.StructureBlockInfo(relativeBlockInfo.pos(), blockState2, relativeBlockInfo.nbt());
    }

    private record Replacement(String config, UnaryOperator<BlockState> transformer) {
        public boolean isEnabled() {
            return CommonConfigs.isEnabled(this.config);
        }

        public BlockState transform(BlockState state) {
            return (BlockState)this.transformer.apply(state);
        }
    }
}

