/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.JarItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.neoforge.QuarkCompatImpl;
import net.mehvahdjukaar.supplementaries.integration.quark.TaterInAJarBlock;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.RegUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.addons.oddities.block.be.MagnetizedBlockBlockEntity;
import org.violetmoon.quark.addons.oddities.block.be.TinyPotatoBlockEntity;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.automation.module.PistonsMoveTileEntitiesModule;
import org.violetmoon.quark.content.building.block.StoolBlock;
import org.violetmoon.quark.content.client.module.UsesForCursesModule;
import org.violetmoon.quark.content.management.module.ExpandedItemInteractionsModule;
import org.violetmoon.quark.content.tools.module.SlimeInABucketModule;
import org.violetmoon.quark.content.tweaks.module.DoubleDoorOpeningModule;
import org.violetmoon.quark.content.tweaks.module.EnhancedLaddersModule;
import org.violetmoon.quark.content.tweaks.module.MoreBannerLayersModule;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.load.ZGatherAdvancementModifiers;
import org.violetmoon.zeta.util.ItemNBTHelper;

public class QuarkCompat {
    public static final String TATER_IN_A_JAR_NAME = "tater_in_a_jar";
    public static final Supplier<Block> TATER_IN_A_JAR = RegUtils.regWithItem("tater_in_a_jar", TaterInAJarBlock::new, new Item.Properties().rarity(Rarity.UNCOMMON));
    public static final Supplier<BlockEntityType<TaterInAJarBlock.Tile>> TATER_IN_A_JAR_TILE = RegUtils.regTile("tater_in_a_jar", () -> BlockEntityType.Builder.of(TaterInAJarBlock.Tile::new, (Block[])new Block[]{TATER_IN_A_JAR.get()}).build(null));
    public static final Supplier<Item> CARTOGRAPHERS_QUILL = null;
    private static Boolean oldFenceValue = null;

    public static void init() {
        Quark.ZETA.loadBus.subscribe(QuarkCompat.class);
    }

    @LoadEvent
    public static void gatherAdvModifiersEvent(ZGatherAdvancementModifiers event) {
        if (CommonConfigs.Tools.CANDY_ENABLED.get().booleanValue()) {
            event.register(event.createBalancedDietMod(Set.of((ItemLike)ModRegistry.CANDY_ITEM.get())));
        }
        if (CommonConfigs.Functional.SACK_PENALTY.get().booleanValue() && CommonConfigs.Functional.SACK_ENABLED.get().booleanValue()) {
            event.register(event.createFuriousCocktailMod(() -> false, Set.of((MobEffect)ModRegistry.OVERENCUMBERED.get())));
        }
        if (CommonConfigs.Functional.FLAX_ENABLED.get().booleanValue()) {
            event.register(event.createASeedyPlaceMod(Set.of(ModRegistry.FLAX.get())));
        }
    }

    public static boolean isFastSlideModuleEnabled() {
        return Quark.ZETA.modules.isEnabled(EnhancedLaddersModule.class) && EnhancedLaddersModule.allowSliding;
    }

    public static boolean isDoubleDoorEnabled() {
        return Quark.ZETA.modules.isEnabled(DoubleDoorOpeningModule.class);
    }

    public static boolean canMoveBlockEntity(BlockState state) {
        return !PistonsMoveTileEntitiesModule.shouldMoveTE((boolean)true, (BlockState)state);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static float getEncumbermentFromBackpack(ItemStack stack) {
        return QuarkCompatImpl.getEncumbermentFromBackpack(stack);
    }

    public static boolean shouldHideOverlay(ItemStack stack) {
        return UsesForCursesModule.staticEnabled && EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP);
    }

    public static int getBannerPatternLimit(int current) {
        return MoreBannerLayersModule.getLimit((int)current);
    }

    public static void tickPiston(Level level, BlockPos pos, BlockState spikes, AABB pistonBB, boolean sameDir, BlockEntity movingTile) {
        List list = level.getEntities(null, pistonBB);
        for (Entity entity : list) {
            BlockEntity blockEntity;
            AABB entityBB;
            Player player;
            if (entity instanceof Player && (player = (Player)entity).isCreative()) {
                return;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!entity.isAlive() || !pistonBB.intersects(entityBB = entity.getBoundingBox())) continue;
            if (CompatHandler.QUARK && (blockEntity = QuarkCompat.getMovingBlockEntity(pos, spikes, level)) instanceof BambooSpikesBlockTile) {
                IBlockHolder te;
                BlockState state;
                BambooSpikesBlockTile tile = (BambooSpikesBlockTile)blockEntity;
                if (tile.interactWithEntity(livingEntity, level) && movingTile instanceof IBlockHolder && (state = (te = (IBlockHolder)movingTile).getHeldBlock()).getBlock() instanceof BambooSpikesBlock) {
                    te.setHeldBlock((BlockState)state.setValue((Property)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
                }
                PistonsMoveTileEntitiesModule.setMovingBlockEntityData((Level)level, (BlockPos)pos, (CompoundTag)tile.saveWithFullMetadata((HolderLookup.Provider)level.registryAccess()));
            }
            entity.hurt(BambooSpikesBlock.getDamageSource(level), sameDir ? 3.0f : 1.0f);
        }
    }

    public static BlockEntity getMovingBlockEntity(BlockPos pos, BlockState state, Level level) {
        Block block = state.getBlock();
        if (!(block instanceof EntityBlock)) {
            return null;
        }
        EntityBlock eb = (EntityBlock)block;
        BlockEntity tile = eb.newBlockEntity(pos, state);
        if (tile == null) {
            return null;
        }
        CompoundTag tileTag = PistonsMoveTileEntitiesModule.getMovingBlockEntityData((Level)level, (BlockPos)pos);
        if (tileTag != null && tile.getType() == BuiltInRegistries.BLOCK_ENTITY_TYPE.get(ResourceLocation.tryParse((String)tileTag.getString("id")))) {
            tile.loadWithComponents(tileTag, (HolderLookup.Provider)level.registryAccess());
        }
        return tile;
    }

    public static InteractionResult tryCaptureTater(JarItem item, UseOnContext context) {
        ItemStack stack;
        TinyPotatoBlockEntity te;
        BlockPos pos = context.getClickedPos();
        Level world = context.getLevel();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TinyPotatoBlockEntity && (te = (TinyPotatoBlockEntity)blockEntity).getType() != TATER_IN_A_JAR_TILE.get() && !(stack = context.getItemInHand()).has(DataComponents.BLOCK_ENTITY_DATA)) {
            if (!world.isClientSide) {
                Player player = context.getPlayer();
                item.playCatchSound(player);
                ItemStack returnItem = new ItemStack((ItemLike)TATER_IN_A_JAR.get());
                if (te.hasCustomName()) {
                    returnItem.set(DataComponents.CUSTOM_NAME, (Object)te.getCustomName());
                }
                Utils.swapItemNBT((Player)player, (InteractionHand)context.getHand(), (ItemStack)stack, (ItemStack)returnItem);
                world.removeBlock(pos, false);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static BlockState getMagnetStateForFlintBlock(BlockEntity be, Direction dir) {
        MagnetizedBlockBlockEntity magnet;
        if (be instanceof MagnetizedBlockBlockEntity && dir == (magnet = (MagnetizedBlockBlockEntity)be).getFacing()) {
            return magnet.getMagnetState();
        }
        return null;
    }

    public static ItemStack getSlimeBucket(Entity entity) {
        if (Quark.ZETA.modules.isEnabled(SlimeInABucketModule.class) && entity.getType() == EntityType.SLIME && ((Slime)entity).getSize() == 1 && entity.isAlive()) {
            ItemStack outStack = new ItemStack((ItemLike)SlimeInABucketModule.slime_in_a_bucket);
            CompoundTag cmp = new CompoundTag();
            entity.save(cmp);
            ItemNBTHelper.setCompound((ItemStack)outStack, (String)"slime_nbt", (CompoundTag)cmp);
            return outStack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean isShulkerDropInOn() {
        return Quark.ZETA.modules.isEnabled(ExpandedItemInteractionsModule.class) && ExpandedItemInteractionsModule.enableShulkerBoxInteraction;
    }

    public static boolean tryRotateStool(Level level, BlockState state, BlockPos pos) {
        if (state.getBlock() instanceof StoolBlock) {
            level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)StoolBlock.BIG));
            return true;
        }
        return false;
    }

    public static ItemStack makeAdventurerQuill(ServerLevel serverLevel, @Nullable TagKey<Structure> destination, int radius, boolean skipKnown, int zoom, ResourceLocation destinationType, @Nullable String name, int color) {
        HolderSet targets = null;
        if (destination != null) {
            Optional v = serverLevel.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(destination);
            if (v.isEmpty()) {
                return ItemStack.EMPTY;
            }
            targets = (HolderSet)v.get();
        }
        return QuarkCompat.makeAdventurerQuill(serverLevel, targets, radius, skipKnown, zoom, destinationType, name, color);
    }

    public static ItemStack makeAdventurerQuill(ServerLevel serverLevel, HolderSet<Structure> targets, int radius, boolean skipKnown, int zoom, ResourceLocation destinationType, @Nullable String name, int color) {
        return null;
    }

    public static void disableFenceGateStuff() {
        oldFenceValue = DoubleDoorOpeningModule.enableFenceGates;
    }

    public static void enableFenceGateStuff() {
        if (oldFenceValue != null) {
            DoubleDoorOpeningModule.enableFenceGates = oldFenceValue;
        }
    }

    public static boolean isGoldBarsOn() {
        return true;
    }
}

