/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration;

import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.IKeyLockable;
import net.mehvahdjukaar.supplementaries.common.items.KeyItem;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class TrinketsCompat {
    public static void init() {
        RegHelper.register((ResourceLocation)Supplementaries.res("trinket"), () -> Trinket.CODEC, net.mehvahdjukaar.supplementaries.common.utils.SlotReference.TYPE_REGISTRY_KEY);
    }

    static IKeyLockable.KeyStatus getKey(Player player, String password) {
        TrinketComponent trinket = TrinketsApi.getTrinketComponent((LivingEntity)player).orElse(null);
        if (trinket != null) {
            List found = trinket.getEquipped(i -> i.is(ModTags.KEYS) || i.getItem() instanceof KeyItem);
            if (found.isEmpty()) {
                return IKeyLockable.KeyStatus.NO_KEY;
            }
            for (Tuple slot : found) {
                ItemStack stack = (ItemStack)slot.getB();
                if (!IKeyLockable.getKeyStatus(stack, password).isCorrect()) continue;
                return IKeyLockable.KeyStatus.CORRECT_KEY;
            }
            return IKeyLockable.KeyStatus.INCORRECT_KEY;
        }
        return IKeyLockable.KeyStatus.NO_KEY;
    }

    static net.mehvahdjukaar.supplementaries.common.utils.SlotReference getQuiver(Player player) {
        List found;
        TrinketComponent trinket = TrinketsApi.getTrinketComponent((LivingEntity)player).orElse(null);
        if (trinket != null && !(found = trinket.getEquipped((Item)ModRegistry.QUIVER_ITEM.get())).isEmpty()) {
            return Trinket.of((SlotReference)((Tuple)found.getFirst()).getA(), trinket);
        }
        return net.mehvahdjukaar.supplementaries.common.utils.SlotReference.EMPTY;
    }

    public record Trinket(String slotName, String groupKey, int id) implements net.mehvahdjukaar.supplementaries.common.utils.SlotReference
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Trinket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Trinket::slotName, (StreamCodec)ByteBufCodecs.STRING_UTF8, Trinket::groupKey, (StreamCodec)ByteBufCodecs.INT, Trinket::id, Trinket::new);

        public static Trinket of(SlotReference ref, TrinketComponent comp) {
            int id = ref.index();
            TrinketInventory inv = ref.inventory();
            SlotType slotType = inv.getSlotType();
            return new Trinket(slotType.getName(), slotType.getGroup(), id);
        }

        @Override
        public ItemStack get(LivingEntity player) {
            TrinketInventory inv;
            Map i;
            TrinketComponent trinket = TrinketsApi.getTrinketComponent((LivingEntity)player).orElse(null);
            if (trinket != null && (i = (Map)trinket.getInventory().get(this.groupKey)) != null && (inv = (TrinketInventory)i.get(this.slotName)) != null) {
                return inv.getItem(this.id);
            }
            return ItemStack.EMPTY;
        }

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends net.mehvahdjukaar.supplementaries.common.utils.SlotReference> getCodec() {
            return CODEC;
        }
    }
}

