/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.reg.neoforge;

import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class FluidHandlerItemCap
implements IFluidHandlerItem {
    protected final int tankVolume;
    protected final Item empty;
    protected final Fluid validContent;
    protected ItemStack container;

    public FluidHandlerItemCap(ItemStack container, int volume, Item empty, Fluid validContent) {
        this.container = container;
        this.tankVolume = volume;
        this.empty = empty;
        this.validContent = validContent;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return fluid.is(this.validContent);
    }

    public FluidStack getFluid() {
        Item item = this.container.getItem();
        if (item instanceof BucketItem) {
            return new FluidStack(((BucketItem)item).content, this.tankVolume);
        }
        return FluidStack.EMPTY;
    }

    protected void setFluid(FluidStack fluidStack) {
        this.container = fluidStack.isEmpty() ? new ItemStack((ItemLike)this.empty) : FluidUtil.getFilledBucket((FluidStack)fluidStack);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tankVolume;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < this.tankVolume || !this.getFluid().isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (action.execute()) {
            this.setFluid(resource);
        }
        return this.tankVolume;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || resource.getAmount() < this.tankVolume) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)resource)) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (this.container.getCount() != 1 || maxDrain < this.tankVolume) {
            return FluidStack.EMPTY;
        }
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setFluid(FluidStack.EMPTY);
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }
}

