/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.lib.geometry;

import com.google.common.annotations.Beta;
import java.util.List;
import java.util.function.Consumer;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;

public interface GuiParent<T extends GuiParent<?>> {
    public double xMin();

    public double xMax();

    public double xSize();

    public double yMin();

    public double yMax();

    public double ySize();

    default public GeoRef get(GeoParam param) {
        return new GeoRef(this, param);
    }

    default public double getValue(GeoParam param) {
        switch (param) {
            case LEFT: {
                return this.xMin();
            }
            case RIGHT: {
                return this.xMax();
            }
            case WIDTH: {
                return this.xSize();
            }
            case TOP: {
                return this.yMin();
            }
            case BOTTOM: {
                return this.yMax();
            }
            case HEIGHT: {
                return this.ySize();
            }
        }
        throw new IllegalStateException("Param: \"" + String.valueOf((Object)param) + "\" Shouldn't Exist! Someone has broken my code! Go yell at them!");
    }

    public List<GuiElement<?>> getChildren();

    public void addChild(GuiElement<?> var1);

    @Beta
    default public T addChild(Consumer<T> createChild) {
        createChild.accept(this);
        return (T)this;
    }

    public void adoptChild(GuiElement<?> var1);

    public void removeChild(GuiElement<?> var1);

    default public boolean isDescendantOf(GuiElement<?> ancestor) {
        return false;
    }

    public Minecraft mc();

    public Font font();

    public int scaledScreenWidth();

    public int scaledScreenHeight();

    public ModularGui getModularGui();

    default public void onScreenInit(Minecraft mc, Font font, int screenWidth, int screenHeight) {
        this.getChildren().forEach(e -> e.onScreenInit(mc, font, screenWidth, screenHeight));
    }

    default public boolean blockMouseOver(GuiElement<?> element, double mouseX, double mouseY) {
        return false;
    }
}

