/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.io.sentry;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import net.creeperhost.polylib.io.sentry.DateUtils;
import net.creeperhost.polylib.io.sentry.IHub;
import net.creeperhost.polylib.io.sentry.ISpan;
import net.creeperhost.polylib.io.sentry.ITransaction;
import net.creeperhost.polylib.io.sentry.NoOpSpan;
import net.creeperhost.polylib.io.sentry.SentryLevel;
import net.creeperhost.polylib.io.sentry.SentryTraceHeader;
import net.creeperhost.polylib.io.sentry.Span;
import net.creeperhost.polylib.io.sentry.SpanContext;
import net.creeperhost.polylib.io.sentry.SpanId;
import net.creeperhost.polylib.io.sentry.SpanStatus;
import net.creeperhost.polylib.io.sentry.TraceState;
import net.creeperhost.polylib.io.sentry.TraceStateHeader;
import net.creeperhost.polylib.io.sentry.TransactionContext;
import net.creeperhost.polylib.io.sentry.TransactionFinishedCallback;
import net.creeperhost.polylib.io.sentry.protocol.Contexts;
import net.creeperhost.polylib.io.sentry.protocol.Request;
import net.creeperhost.polylib.io.sentry.protocol.SentryId;
import net.creeperhost.polylib.io.sentry.protocol.SentryTransaction;
import net.creeperhost.polylib.io.sentry.protocol.User;
import net.creeperhost.polylib.io.sentry.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryTracer
implements ITransaction {
    @NotNull
    private final SentryId eventId = new SentryId();
    @NotNull
    private final Span root;
    @NotNull
    private final List<Span> children = new CopyOnWriteArrayList<Span>();
    @NotNull
    private final IHub hub;
    @NotNull
    private final Contexts contexts = new Contexts();
    @Nullable
    private Request request;
    @NotNull
    private String name;
    private final boolean waitForChildren;
    @NotNull
    private FinishStatus finishStatus = FinishStatus.NOT_FINISHED;
    @Nullable
    private final TransactionFinishedCallback transactionFinishedCallback;
    @Nullable
    private TraceState traceState;

    public SentryTracer(@NotNull TransactionContext context, @NotNull IHub hub) {
        this(context, hub, null);
    }

    public SentryTracer(@NotNull TransactionContext context, @NotNull IHub hub, boolean waitForChildren, @Nullable TransactionFinishedCallback transactionFinishedCallback) {
        this(context, hub, null, waitForChildren, transactionFinishedCallback);
    }

    SentryTracer(@NotNull TransactionContext context, @NotNull IHub hub, @Nullable Date startTimestamp) {
        this(context, hub, startTimestamp, false, null);
    }

    SentryTracer(@NotNull TransactionContext context, @NotNull IHub hub, @Nullable Date startTimestamp, boolean waitForChildren, @Nullable TransactionFinishedCallback transactionFinishedCallback) {
        Objects.requireNonNull(context, "context is required");
        Objects.requireNonNull(hub, "hub is required");
        this.root = new Span(context, this, hub, startTimestamp);
        this.name = context.getName();
        this.hub = hub;
        this.waitForChildren = waitForChildren;
        this.transactionFinishedCallback = transactionFinishedCallback;
    }

    @NotNull
    public List<Span> getChildren() {
        return this.children;
    }

    @NotNull
    public Date getStartTimestamp() {
        return this.root.getStartTimestamp();
    }

    @Nullable
    public Date getTimestamp() {
        return this.root.getTimestamp();
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description) {
        ISpan span = this.createChild(parentSpanId, operation);
        span.setDescription(description);
        return span;
    }

    @NotNull
    ISpan startChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description, @Nullable Date timestamp) {
        return this.createChild(parentSpanId, operation, description, timestamp);
    }

    @NotNull
    private ISpan createChild(@NotNull SpanId parentSpanId, @NotNull String operation) {
        return this.createChild(parentSpanId, operation, null, null);
    }

    @NotNull
    private ISpan createChild(@NotNull SpanId parentSpanId, @NotNull String operation, @Nullable String description, @Nullable Date timestamp) {
        if (this.root.isFinished()) {
            return NoOpSpan.getInstance();
        }
        Objects.requireNonNull(parentSpanId, "parentSpanId is required");
        Objects.requireNonNull(operation, "operation is required");
        Span span = new Span(this.root.getTraceId(), parentSpanId, this, operation, this.hub, timestamp, __ -> {
            FinishStatus finishStatus = this.finishStatus;
            if (finishStatus.isFinishing) {
                this.finish(finishStatus.spanStatus);
            }
        });
        span.setDescription(description);
        this.children.add(span);
        return span;
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation) {
        return this.startChild(operation, null);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description, @Nullable Date timestamp) {
        return this.createChild(operation, description, timestamp);
    }

    @Override
    @NotNull
    public ISpan startChild(@NotNull String operation, @Nullable String description) {
        return this.createChild(operation, description, null);
    }

    @NotNull
    private ISpan createChild(@NotNull String operation, @Nullable String description, @Nullable Date timestamp) {
        if (this.root.isFinished()) {
            return NoOpSpan.getInstance();
        }
        if (this.children.size() < this.hub.getOptions().getMaxSpans()) {
            return this.root.startChild(operation, description, timestamp);
        }
        this.hub.getOptions().getLogger().log(SentryLevel.WARNING, "Span operation: %s, description: %s dropped due to limit reached. Returning NoOpSpan.", operation, description);
        return NoOpSpan.getInstance();
    }

    @Override
    @NotNull
    public SentryTraceHeader toSentryTrace() {
        return this.root.toSentryTrace();
    }

    @Override
    public void finish() {
        this.finish(this.getStatus());
    }

    @Override
    public void finish(@Nullable SpanStatus status) {
        this.finishStatus = FinishStatus.finishing(status);
        if (!(this.root.isFinished() || this.waitForChildren && !this.hasAllChildrenFinished())) {
            this.root.finish(this.finishStatus.spanStatus);
            Date finishTimestamp = this.root.getTimestamp();
            if (finishTimestamp == null) {
                this.hub.getOptions().getLogger().log(SentryLevel.WARNING, "Root span - op: %s, description: %s - has no timestamp set, when finishing unfinished spans.", this.root.getOperation(), this.root.getDescription());
                finishTimestamp = DateUtils.getCurrentDateTime();
            }
            for (Span child : this.children) {
                if (child.isFinished()) continue;
                child.finish(SpanStatus.DEADLINE_EXCEEDED, finishTimestamp);
            }
            this.hub.configureScope(scope -> scope.withTransaction(transaction -> {
                if (transaction == this) {
                    scope.clearTransaction();
                }
            }));
            SentryTransaction transaction = new SentryTransaction(this);
            if (this.transactionFinishedCallback != null) {
                this.transactionFinishedCallback.execute(this);
            }
            this.hub.captureTransaction(transaction, this.traceState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TraceState traceState() {
        if (this.hub.getOptions().isTraceSampling()) {
            SentryTracer sentryTracer = this;
            synchronized (sentryTracer) {
                if (this.traceState == null) {
                    AtomicReference userAtomicReference = new AtomicReference();
                    this.hub.configureScope(scope -> userAtomicReference.set(scope.getUser()));
                    this.traceState = new TraceState(this, (User)userAtomicReference.get(), this.hub.getOptions());
                }
                return this.traceState;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public TraceStateHeader toTraceStateHeader() {
        TraceState traceState = this.traceState();
        if (this.hub.getOptions().isTraceSampling() && traceState != null) {
            return TraceStateHeader.fromTraceState(traceState, this.hub.getOptions().getSerializer(), this.hub.getOptions().getLogger());
        }
        return null;
    }

    private boolean hasAllChildrenFinished() {
        ArrayList<Span> spans = new ArrayList<Span>(this.children);
        if (!spans.isEmpty()) {
            for (Span span : spans) {
                if (span.isFinished()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void setOperation(@NotNull String operation) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setOperation(operation);
    }

    @Override
    @NotNull
    public String getOperation() {
        return this.root.getOperation();
    }

    @Override
    public void setDescription(@Nullable String description) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setDescription(description);
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.root.getDescription();
    }

    @Override
    public void setStatus(@Nullable SpanStatus status) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setStatus(status);
    }

    @Override
    @Nullable
    public SpanStatus getStatus() {
        return this.root.getStatus();
    }

    @Override
    public void setThrowable(@Nullable Throwable throwable) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setThrowable(throwable);
    }

    @Override
    @Nullable
    public Throwable getThrowable() {
        return this.root.getThrowable();
    }

    @Override
    @NotNull
    public SpanContext getSpanContext() {
        return this.root.getSpanContext();
    }

    @Override
    public void setTag(@NotNull String key, @NotNull String value) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setTag(key, value);
    }

    @Override
    @Nullable
    public String getTag(@NotNull String key) {
        return this.root.getTag(key);
    }

    @Override
    public boolean isFinished() {
        return this.root.isFinished();
    }

    @Override
    public void setData(@NotNull String key, @NotNull Object value) {
        if (this.root.isFinished()) {
            return;
        }
        this.root.setData(key, value);
    }

    @Override
    @Nullable
    public Object getData(@NotNull String key) {
        return this.root.getData(key);
    }

    @Nullable
    public Map<String, Object> getData() {
        return this.root.getData();
    }

    @Override
    @Nullable
    public Boolean isSampled() {
        return this.root.isSampled();
    }

    @Override
    public void setName(@NotNull String name) {
        if (this.root.isFinished()) {
            return;
        }
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public void setRequest(@Nullable Request request) {
        if (this.root.isFinished()) {
            return;
        }
        this.request = request;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public Request getRequest() {
        return this.request;
    }

    @Override
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public Contexts getContexts() {
        return this.contexts;
    }

    @Override
    @NotNull
    public List<Span> getSpans() {
        return this.children;
    }

    @Override
    @Nullable
    public Span getLatestActiveSpan() {
        ArrayList<Span> spans = new ArrayList<Span>(this.children);
        if (!spans.isEmpty()) {
            for (int i = spans.size() - 1; i >= 0; --i) {
                if (((Span)spans.get(i)).isFinished()) continue;
                return (Span)spans.get(i);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public SentryId getEventId() {
        return this.eventId;
    }

    @NotNull
    Span getRoot() {
        return this.root;
    }

    private static final class FinishStatus {
        static final FinishStatus NOT_FINISHED = FinishStatus.notFinished();
        private final boolean isFinishing;
        @Nullable
        private final SpanStatus spanStatus;

        @NotNull
        static FinishStatus finishing(@Nullable SpanStatus finishStatus) {
            return new FinishStatus(true, finishStatus);
        }

        @NotNull
        private static FinishStatus notFinished() {
            return new FinishStatus(false, null);
        }

        private FinishStatus(boolean isFinishing, @Nullable SpanStatus spanStatus) {
            this.isFinishing = isFinishing;
            this.spanStatus = spanStatus;
        }
    }
}

