/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.client.hatdisplay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fonnymunkey.simplehats.client.hatdisplay.HatDisplayLayer;
import fonnymunkey.simplehats.client.hatdisplay.HatDisplayModel;
import fonnymunkey.simplehats.common.entity.HatDisplay;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class HatDisplayRenderer
extends LivingEntityRenderer<HatDisplay, HatDisplayModel<HatDisplay>> {
    public static final ResourceLocation HATDISPLAY_TEXTURE = ResourceLocation.tryBuild((String)"simplehats", (String)"textures/entity/hatdisplay.png");
    public static final ModelLayerLocation HATDISPLAY_LOCATION = new ModelLayerLocation(HATDISPLAY_TEXTURE, "main");

    public HatDisplayRenderer(EntityRendererProvider.Context context) {
        super(context, new HatDisplayModel(context.bakeLayer(HATDISPLAY_LOCATION)), 0.0f);
        this.addLayer(new HatDisplayLayer(this));
    }

    public ResourceLocation getTextureLocation(HatDisplay entity) {
        return HATDISPLAY_TEXTURE;
    }

    protected void setupRotations(HatDisplay entityLiving, PoseStack matrixStack, float animationProgress, float rotationYaw, float partialTicks, float scale) {
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
        float f = (float)(entityLiving.level().getGameTime() - entityLiving.lastHit) + partialTicks;
        if (f < 5.0f) {
            matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(f / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }

    protected boolean shouldShowName(HatDisplay entity) {
        double d0 = this.entityRenderDispatcher.distanceToSqr((Entity)entity);
        return d0 < 4096.0 && entity.hasCustomName();
    }
}

