/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.randomvillagenames_common_forge.util;

import com.natamus.collective_common_forge.functions.FABFunctions;
import com.natamus.collective_common_forge.functions.SignFunctions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public class Util {
    private static final List<String> zoneprefixes = new ArrayList<String>(Arrays.asList("[na]", "[area]", "[region]", "[zone]"));

    public static boolean hasAreasSignNeaby(Level level, BlockPos pos, int radius) {
        List signsaround = FABFunctions.getAllTileEntityPositionsNearbyPosition((BlockEntityType)BlockEntityType.SIGN, (Integer)radius, (Level)level, (BlockPos)pos);
        for (BlockPos signpos : signsaround) {
            BlockEntity te = level.getBlockEntity(signpos);
            if (!(te instanceof SignBlockEntity) || !Util.isAreasSign((SignBlockEntity)te)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAreasSign(SignBlockEntity signentity) {
        int i = -1;
        Iterator iterator = SignFunctions.getSignText((SignBlockEntity)signentity).iterator();
        if (iterator.hasNext()) {
            String line = (String)iterator.next();
            if (++i == 0 && Util.hasZonePrefix(line)) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasZonePrefix(String line) {
        for (String prefix : zoneprefixes) {
            if (!line.toLowerCase().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSign(Block block) {
        return block instanceof StandingSignBlock || block instanceof WallSignBlock;
    }

    public static boolean isOverwritableBlockOrSign(Block block) {
        return block.equals(Blocks.AIR) || Util.isSign(block) || block instanceof BushBlock || block instanceof SnowLayerBlock;
    }
}

