/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.brewery.core.block.WallDecorationBlock;
import net.satisfy.brewery.core.block.entity.WallDecorationBlockEntity;

public class WallDecorationBlockRenderer
implements BlockEntityRenderer<WallDecorationBlockEntity> {
    public void render(WallDecorationBlockEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 1.0, 0.5);
        Direction facing = (Direction)entity.getBlockState().getValue((Property)WallDecorationBlock.FACING);
        float rotation = facing == Direction.NORTH ? 180.0f : (facing == Direction.WEST ? -90.0f : (facing == Direction.EAST ? 90.0f : 0.0f));
        poseStack.mulPose(Axis.YP.rotationDegrees(rotation));
        poseStack.translate(0.0, -0.45, -0.425);
        poseStack.scale(0.01f, -0.01f, 0.01f);
        Font font = Minecraft.getInstance().font;
        boolean glow = entity.isGlowing();
        Component text = entity.getText(0);
        String str = text.getString();
        if (str.length() > 8) {
            str = str.substring(0, 8);
        }
        if (!str.isEmpty()) {
            poseStack.pushPose();
            if (glow) {
                MultiBufferSource.BufferSource seeThroughBuffer = Minecraft.getInstance().renderBuffers().bufferSource();
                font.drawInBatch(Component.literal((String)str).getVisualOrderText(), (float)(-font.width(str)) / 2.0f, 0.0f, 16441264, false, poseStack.last().pose(), (MultiBufferSource)seeThroughBuffer, Font.DisplayMode.SEE_THROUGH, 0, 0xF000F0);
                seeThroughBuffer.endBatch();
            } else {
                font.drawInBatch(Component.literal((String)str).getVisualOrderText(), (float)(-font.width(str)) / 2.0f, 0.0f, 16441264, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, light);
            }
            poseStack.popPose();
        }
        poseStack.popPose();
    }
}

