/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.brewery.core.block.HopsCropBodyBlock;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.core.block.RopeBlock;
import net.satisfy.farm_and_charm.core.block.crops.ClimbingCropBlock;
import org.jetbrains.annotations.NotNull;

public class HopsCropHeadBlock
extends ClimbingCropBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;

    public HopsCropHeadBlock(BlockBehaviour.Properties properties) {
        super(properties, SHAPE);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(false)));
    }

    protected IntegerProperty getAgeProperty() {
        return AGE;
    }

    protected int getMaxAge() {
        return 4;
    }

    protected ItemLike getRipeItem() {
        return (ItemLike)ObjectRegistry.HOPS.get();
    }

    protected ItemLike getRottenItem() {
        return (ItemLike)ObjectRegistry.HOPS.get();
    }

    public static int getMaxHeight(LevelAccessor level, BlockPos pos) {
        BlockState self = level.getBlockState(pos);
        boolean supportedFlag = self.hasProperty((Property)SUPPORTED) && (Boolean)self.getValue((Property)SUPPORTED) != false;
        boolean ropeAbove = level.getBlockState(pos.above()).getBlock() instanceof RopeBlock || level.getBlockState(pos.above(2)).getBlock() instanceof RopeBlock;
        return supportedFlag || ropeAbove ? 4 : 2;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.tick(state, level, pos, random);
        if (HopsCropHeadBlock.getHeight((BlockPos)pos, (LevelAccessor)level) > HopsCropHeadBlock.getMaxHeight((LevelAccessor)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.randomTick(state, level, pos, random);
        if (level.getRawBrightness(pos, 0) >= 9 && random.nextFloat() < 0.2f) {
            boolean ropeOk;
            BlockPos up = pos.above();
            BlockState rope = level.getBlockState(up);
            boolean bl = ropeOk = !(!(rope.getBlock() instanceof RopeBlock) || rope.hasProperty((Property)RopeBlock.DOWN) && (Boolean)rope.getValue((Property)RopeBlock.DOWN) == false || rope.hasProperty((Property)RopeBlock.CENTER_PIECE) && (Boolean)rope.getValue((Property)RopeBlock.CENTER_PIECE) == false || rope.hasProperty((Property)RopeBlock.ROPE_KNOT) && (Boolean)rope.getValue((Property)RopeBlock.ROPE_KNOT) != false || rope.hasProperty((Property)RopeBlock.SUPPORTING_ROPE_KNOT) && (Boolean)rope.getValue((Property)RopeBlock.SUPPORTING_ROPE_KNOT) != false);
            if (((Boolean)state.getValue((Property)SUPPORTED)).booleanValue() && ropeOk && HopsCropHeadBlock.getHeight((BlockPos)pos, (LevelAccessor)level) < HopsCropHeadBlock.getMaxHeight((LevelAccessor)level, pos)) {
                boolean supported = (Boolean)state.getValue((Property)SUPPORTED);
                BlockState body = (BlockState)((BlockState)((Block)ObjectRegistry.HOPS_CROP_BODY.get()).defaultBlockState().setValue((Property)HopsCropBodyBlock.AGE, (Comparable)((Integer)state.getValue((Property)AGE)))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(supported));
                level.setBlock(pos, body, 2);
                level.setBlockAndUpdate(up, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(supported)));
                return;
            }
            if ((Integer)state.getValue((Property)AGE) < this.getMaxAge()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)));
            }
        }
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        boolean ropeOk;
        BlockPos up = pos.above();
        BlockState rope = level.getBlockState(up);
        boolean bl = ropeOk = !(!(rope.getBlock() instanceof RopeBlock) || rope.hasProperty((Property)RopeBlock.DOWN) && (Boolean)rope.getValue((Property)RopeBlock.DOWN) == false || rope.hasProperty((Property)RopeBlock.CENTER_PIECE) && (Boolean)rope.getValue((Property)RopeBlock.CENTER_PIECE) == false || rope.hasProperty((Property)RopeBlock.ROPE_KNOT) && (Boolean)rope.getValue((Property)RopeBlock.ROPE_KNOT) != false || rope.hasProperty((Property)RopeBlock.SUPPORTING_ROPE_KNOT) && (Boolean)rope.getValue((Property)RopeBlock.SUPPORTING_ROPE_KNOT) != false);
        if (((Boolean)state.getValue((Property)SUPPORTED)).booleanValue() && ropeOk && HopsCropHeadBlock.getHeight((BlockPos)pos, (LevelAccessor)level) < HopsCropHeadBlock.getMaxHeight((LevelAccessor)level, pos)) {
            boolean supported = (Boolean)state.getValue((Property)SUPPORTED);
            BlockState body = (BlockState)((BlockState)((Block)ObjectRegistry.HOPS_CROP_BODY.get()).defaultBlockState().setValue((Property)HopsCropBodyBlock.AGE, (Comparable)((Integer)state.getValue((Property)AGE)))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(supported));
            level.setBlock(pos, body, 2);
            level.setBlockAndUpdate(up, (BlockState)((BlockState)this.defaultBlockState().setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)SUPPORTED, (Comparable)Boolean.valueOf(supported)));
            return;
        }
        if ((Integer)state.getValue((Property)AGE) < this.getMaxAge()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)));
        } else {
            this.dropFruits((Level)level, pos, state);
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (dir == Direction.DOWN && !state.canSurvive((LevelReader)level, pos)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
        return state;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }
}

