/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.block.entity;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.brewery.core.block.property.BrewMaterial;
import net.satisfy.brewery.core.block.property.Heat;
import net.satisfy.brewery.core.block.property.Liquid;
import net.satisfy.brewery.core.entity.BeerElementalEntity;
import net.satisfy.brewery.core.event.brew_event.BrewEvent;
import net.satisfy.brewery.core.event.brew_event.BrewEvents;
import net.satisfy.brewery.core.event.brew_event.BrewHelper;
import net.satisfy.brewery.core.item.DrinkBlockItem;
import net.satisfy.brewery.core.recipe.BrewingRecipe;
import net.satisfy.brewery.core.registry.BlockStateRegistry;
import net.satisfy.brewery.core.registry.EntityTypeRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import net.satisfy.brewery.core.registry.RecipeTypeRegistry;
import net.satisfy.brewery.core.registry.SoundEventRegistry;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import net.satisfy.farm_and_charm.core.world.ImplementedInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewstationBlockEntity
extends BlockEntity
implements ImplementedInventory,
BlockEntityTicker<BrewstationBlockEntity> {
    @NotNull
    private Set<BlockPos> components = new HashSet<BlockPos>(4);
    private static final int MAX_BREW_TIME = 1200;
    private static final int MIN_TIME_FOR_EVENT = 100;
    private static final int MAX_TIME_FOR_EVENT = 300;
    private static final int SOUND_DURATION = 60;
    private int soundTime;
    private int brewTime;
    private int timeToNextEvent = Integer.MIN_VALUE;
    private final Set<BrewEvent> runningEvents = new HashSet<BrewEvent>();
    private int solved;
    private int totalEvents;
    private int eventQuota = -1;
    private int overflowStarted;
    private int overflowSolved;
    private NonNullList<ItemStack> ingredients;
    private ItemStack beer = ItemStack.EMPTY;
    private final SoundEvent spawnEntitySound = (SoundEvent)SoundEventRegistry.BREWSTATION_PROCESS_FAILED.get();

    public BrewstationBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)EntityTypeRegistry.BREWINGSTATION_BLOCK_ENTITY.get(), blockPos, blockState);
        this.ingredients = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
    }

    public void setComponents(BlockPos ... components) {
        if (components.length != 4) {
            return;
        }
        this.components.addAll(Arrays.asList(components));
    }

    public ItemInteractionResult addIngredient(ItemStack itemStack) {
        for (int i = 0; i < 3; ++i) {
            ItemStack stack = (ItemStack)this.ingredients.get(i);
            if (!stack.isEmpty()) continue;
            this.setItem(i, itemStack.split(1));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public ItemStack getBeer() {
        if (this.beer.isEmpty()) {
            return null;
        }
        ItemStack beerStack = this.beer.copy();
        beerStack.setCount(1);
        this.beer.shrink(1);
        if (this.beer.isEmpty() && this.level != null) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue(BlockStateRegistry.LIQUID, (Comparable)((Object)Liquid.EMPTY)));
        }
        return beerStack;
    }

    @Nullable
    public ItemStack removeIngredient() {
        for (int i = 0; i < 3; ++i) {
            ItemStack itemStack = (ItemStack)this.ingredients.get(i);
            if (itemStack.isEmpty()) continue;
            this.ingredients.set(i, (Object)ItemStack.EMPTY);
            return itemStack;
        }
        return null;
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, BrewstationBlockEntity blockEntity) {
        if (level.isClientSide) {
            return;
        }
        if (!this.beer.isEmpty()) {
            return;
        }
        RecipeHolder<BrewingRecipe> active = this.findActiveRecipe(level);
        if (active == null) {
            this.endBrewing();
            return;
        }
        if (this.eventQuota < 0) {
            this.eventQuota = this.computeEventQuota();
        }
        if (this.soundTime >= 60) {
            level.playSound(null, blockPos, (SoundEvent)SoundEventRegistry.BREWSTATION_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            this.soundTime = 0;
        }
        ++this.soundTime;
        if (this.timeToNextEvent == Integer.MIN_VALUE) {
            this.setTimeToEvent();
        }
        BrewHelper.checkRunningEvents(this);
        int timeLeft = 1200 - this.brewTime;
        if (this.brewTime >= 1200) {
            RegistryAccess access = level.registryAccess();
            this.brew(active.value(), access);
        } else if (timeLeft >= 100 && this.timeToNextEvent <= 0 && this.totalEvents < this.eventQuota && this.runningEvents.size() < BrewEvents.BREW_EVENTS.size()) {
            ResourceLocation eventId;
            BrewEvent event = BrewHelper.getRdmEvent(this);
            if (event != null && (eventId = BrewEvents.getId(event)) != null) {
                if (eventId.equals((Object)BrewEvents.KETTLE_EVENT)) {
                    ++this.overflowStarted;
                }
                event.start(this.components, level);
                this.runningEvents.add(event);
                ++this.totalEvents;
            }
            this.setTimeToEvent();
        }
        ++this.brewTime;
        --this.timeToNextEvent;
    }

    private void setTimeToEvent() {
        if (this.level != null) {
            this.timeToNextEvent = BrewstationBlockEntity.getRandomHighNumber(this.level.getRandom(), 100, 300);
        }
    }

    public static int getRandomHighNumber(RandomSource rnd, int lowerBound, int upperBound) {
        int range = upperBound - lowerBound + 1;
        return upperBound - (int)(Math.pow(rnd.nextDouble(), 1.5) * (double)range);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canBrew(@Nullable Recipe<?> recipe) {
        if (recipe == null) return false;
        if (this.level == null) {
            return false;
        }
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        if (!(recipe instanceof BrewingRecipe)) return false;
        BrewingRecipe brewingRecipe = (BrewingRecipe)recipe;
        if (((BrewMaterial)((Object)blockState.getValue(BlockStateRegistry.MATERIAL))).getLevel() < brewingRecipe.getMaterial().getLevel()) return false;
        if (blockState.getValue(BlockStateRegistry.LIQUID) == Liquid.EMPTY) return false;
        if (this.level.getBlockState(BrewHelper.getBlock((Block)ObjectRegistry.BREW_OVEN.get(), this.components, this.level)).getValue(BlockStateRegistry.HEAT) == Heat.OFF) return false;
        return true;
    }

    private void brew(Recipe<?> recipe, RegistryAccess access) {
        ItemStack resultStack = recipe.getResultItem((HolderLookup.Provider)access);
        Item item = resultStack.getItem();
        if (item instanceof DrinkBlockItem) {
            DrinkBlockItem drinkItem = (DrinkBlockItem)item;
            assert (this.level != null);
            int quality = this.level.getBlockState(this.getBlockPos()).getValue(BlockStateRegistry.MATERIAL) == BrewMaterial.NETHERITE ? 3 : this.solved + 1;
            DrinkBlockItem.addQuality(resultStack, quality);
            drinkItem.addCount(resultStack, this.solved == 0 ? 1 : this.solved + 1);
            this.solved = quality;
        }
        this.beer = resultStack;
        this.spawnElementals();
        this.endBrewing();
        if (this.level != null) {
            BlockState blockState = this.level.getBlockState(this.getBlockPos());
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)blockState.setValue(BlockStateRegistry.LIQUID, (Comparable)((Object)Liquid.BEER)));
            BlockPos ovenPos = BrewHelper.getBlock((Block)ObjectRegistry.BREW_OVEN.get(), this.components, this.level);
            BlockState ovenState = this.level.getBlockState(ovenPos);
            this.level.setBlockAndUpdate(ovenPos, (BlockState)ovenState.setValue(BlockStateRegistry.HEAT, (Comparable)((Object)Heat.OFF)));
            BlockPos timerPos = BrewHelper.getBlock((Block)ObjectRegistry.BREW_TIMER.get(), this.components, this.level);
            BlockState timerState = this.level.getBlockState(timerPos);
            this.level.setBlockAndUpdate(timerPos, (BlockState)timerState.setValue((Property)BlockStateRegistry.TIME, (Comparable)Boolean.valueOf(false)));
        }
        block0: for (Ingredient ingredient : recipe.getIngredients()) {
            for (int i = 0; i < 3; ++i) {
                ItemStack itemStack = (ItemStack)this.ingredients.get(i);
                if (!ingredient.test(itemStack)) continue;
                this.removeItem(i, 1);
                continue block0;
            }
        }
    }

    private void spawnElementals() {
        boolean highFailRate;
        if (this.level == null) {
            return;
        }
        BlockState state = this.level.getBlockState(this.getBlockPos());
        BrewMaterial material = (BrewMaterial)((Object)state.getValue(BlockStateRegistry.MATERIAL));
        boolean overflowUnresolved = this.overflowStarted > this.overflowSolved;
        int failed = Math.max(0, this.totalEvents - this.solved);
        boolean bl = highFailRate = this.totalEvents > 0 && failed * 2 > this.totalEvents;
        int count = highFailRate ? this.level.getRandom().nextInt(2, 4) : (overflowUnresolved ? (material == BrewMaterial.COPPER ? 1 : 2) : 0);
        if (count <= 0) {
            return;
        }
        BlockPos base = BrewHelper.getBlock((Block)ObjectRegistry.BREW_OVEN.get(), this.components, this.level);
        if (base == null) {
            return;
        }
        for (int n = 0; n < count; ++n) {
            BeerElementalEntity e = new BeerElementalEntity((EntityType<? extends Monster>)((EntityType)EntityTypeRegistry.BEER_ELEMENTAL.get()), this.level);
            double ox = (double)this.level.getRandom().nextInt(-1, 2) + 0.5;
            double oz = (double)this.level.getRandom().nextInt(-1, 2) + 0.5;
            e.setPos((double)base.getX() + ox, base.getY() + 1, (double)base.getZ() + oz);
            e.setHealth(20.0f);
            this.level.addFreshEntity((Entity)e);
            this.level.playSound(null, e.blockPosition(), this.spawnEntitySound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.overflowStarted = 0;
        this.overflowSolved = 0;
    }

    public void onEventFinished(BrewEvent event, boolean success) {
        ResourceLocation id = BrewEvents.getId(event);
        if (id == null) {
            return;
        }
        if (id.equals((Object)BrewEvents.KETTLE_EVENT) && success) {
            ++this.overflowSolved;
        }
    }

    private int computeEventQuota() {
        BrewMaterial material = (BrewMaterial)((Object)this.getBlockState().getValue(BlockStateRegistry.MATERIAL));
        assert (this.level != null);
        RandomSource rnd = this.level.getRandom();
        return switch (material) {
            default -> throw new MatchException(null, null);
            case BrewMaterial.WOOD -> rnd.nextInt(8, 13);
            case BrewMaterial.COPPER -> rnd.nextInt(4, 7);
            case BrewMaterial.NETHERITE -> rnd.nextInt(1, 3);
        };
    }

    public void endBrewing() {
        BrewHelper.finishEvents(this);
        this.brewTime = 0;
        this.totalEvents = 0;
        this.soundTime = 60;
        this.timeToNextEvent = Integer.MIN_VALUE;
        this.eventQuota = -1;
        this.overflowStarted = 0;
        this.overflowSolved = 0;
    }

    public boolean isPartOf(BlockPos blockPos) {
        return this.components.contains(blockPos);
    }

    public void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        if (!this.components.isEmpty()) {
            GeneralUtil.putBlockPoses((CompoundTag)compoundTag, this.components);
        }
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.ingredients, (HolderLookup.Provider)provider);
        if (!this.beer.isEmpty()) {
            compoundTag.put("beer", this.beer.save(provider, (Tag)new CompoundTag()));
        }
        compoundTag.putInt("solved", this.solved);
        compoundTag.putInt("brewTime", this.brewTime);
        compoundTag.putInt("totalEvents", this.totalEvents);
        compoundTag.putInt("timeToNextEvent", this.timeToNextEvent);
        compoundTag.putInt("eventQuota", this.eventQuota);
        compoundTag.putInt("overflowStarted", this.overflowStarted);
        compoundTag.putInt("overflowSolved", this.overflowSolved);
        BrewHelper.saveAdditional(this, compoundTag);
    }

    public void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        this.components = GeneralUtil.readBlockPoses((CompoundTag)compoundTag);
        this.ingredients = NonNullList.withSize((int)3, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.ingredients, (HolderLookup.Provider)provider);
        if (compoundTag.contains("beer")) {
            this.beer = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compoundTag.getCompound("beer"));
        }
        this.solved = compoundTag.getInt("solved");
        this.brewTime = compoundTag.getInt("brewTime");
        this.totalEvents = compoundTag.getInt("totalEvents");
        this.timeToNextEvent = compoundTag.getInt("timeToNextEvent");
        this.eventQuota = compoundTag.getInt("eventQuota");
        this.overflowStarted = compoundTag.getInt("overflowStarted");
        this.overflowSolved = compoundTag.getInt("overflowSolved");
        BrewHelper.load(this, compoundTag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void growSolved() {
        ++this.solved;
    }

    public Set<BrewEvent> getRunningEvents() {
        return this.runningEvents;
    }

    @NotNull
    public Set<BlockPos> getComponents() {
        return this.components;
    }

    public List<ItemStack> getIngredient() {
        return this.ingredients;
    }

    public NonNullList<ItemStack> getItems() {
        return this.ingredients;
    }

    public boolean stillValid(Player player) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    @Nullable
    private RecipeHolder<BrewingRecipe> findActiveRecipe(Level level) {
        List recipeHolders = level.getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.BREWING_RECIPE_TYPE.get());
        for (RecipeHolder holder : recipeHolders) {
            BrewingRecipe r = (BrewingRecipe)holder.value();
            if (!this.canBrew(r) || !this.ingredientsMatch(r)) continue;
            return holder;
        }
        return null;
    }

    private boolean ingredientsMatch(BrewingRecipe recipe) {
        NonNullList<Ingredient> req = recipe.getIngredients();
        boolean[] used = new boolean[this.ingredients.size()];
        int matched = 0;
        for (Ingredient ing : req) {
            boolean found = false;
            for (int i = 0; i < this.ingredients.size(); ++i) {
                if (used[i] || !ing.test((ItemStack)this.ingredients.get(i))) continue;
                used[i] = true;
                found = true;
                ++matched;
                break;
            }
            if (found) continue;
            return false;
        }
        return matched == req.size();
    }
}

