/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.effect;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MiningEffect
extends MobEffect {
    public MiningEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            MobEffectInstance newEffect;
            Player player = (Player)entity;
            int y = player.getBlockY();
            MobEffectInstance currentEffect = player.getEffect(MobEffects.DIG_SPEED);
            if (this.shouldUpdateEffect(currentEffect, newEffect = this.determineEffectByYLevel(y))) {
                player.removeEffect(MobEffects.DIG_SPEED);
                player.addEffect(newEffect);
            }
        }
        return super.applyEffectTick(entity, amplifier);
    }

    private MobEffectInstance determineEffectByYLevel(int y) {
        if (y >= 50) {
            return new MobEffectInstance(MobEffects.DIG_SPEED, 200, 0, false, false);
        }
        if (y >= 30) {
            return new MobEffectInstance(MobEffects.DIG_SPEED, 200, 1, false, false);
        }
        if (y >= 0) {
            return new MobEffectInstance(MobEffects.DIG_SPEED, 200, 2, false, false);
        }
        if (y >= -20) {
            return new MobEffectInstance(MobEffects.DIG_SPEED, 200, 3, false, false);
        }
        return new MobEffectInstance(MobEffects.DIG_SPEED, 200, 4, false, false);
    }

    private boolean shouldUpdateEffect(MobEffectInstance currentEffect, MobEffectInstance newEffect) {
        return currentEffect == null || currentEffect.getAmplifier() != newEffect.getAmplifier();
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }
}

