/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.effect;

import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class RepulsionEffect
extends MobEffect {
    public RepulsionEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            List entities = player.level().getEntitiesOfClass(LivingEntity.class, player.getBoundingBox().inflate(4.0), e -> e != player);
            for (LivingEntity target : entities) {
                double dz;
                double dx = target.getX() - player.getX();
                double distance = Math.sqrt(dx * dx + (dz = target.getZ() - player.getZ()) * dz);
                if (!(distance > 0.0)) continue;
                target.setDeltaMovement(target.getDeltaMovement().add(dx / distance * (0.2 + 0.1 * (double)amplifier), 0.1, dz / distance * (0.2 + 0.1 * (double)amplifier)));
            }
        }
        return super.applyEffectTick(entity, amplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 40 == 0;
    }
}

