/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.brewery.core.entity;

import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.satisfy.brewery.core.entity.BeerElementalEntity;
import net.satisfy.brewery.core.registry.EntityTypeRegistry;
import net.satisfy.brewery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class DarkBrewEntity
extends ThrowableItemProjectile {
    public DarkBrewEntity(Level world, LivingEntity owner) {
        super((EntityType)EntityTypeRegistry.DARK_BREW.get(), owner, world);
    }

    public DarkBrewEntity(EntityType<? extends DarkBrewEntity> entityType, Level world) {
        super(entityType, world);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)ObjectRegistry.DARK_BREW.get();
    }

    private ParticleOptions getParticleParameters() {
        SimpleParticleType particle;
        ItemStack itemStack = this.getDefaultItem().getDefaultInstance();
        Object object = particle = itemStack.isEmpty() ? ParticleTypes.LANDING_HONEY : new ItemParticleOption(ParticleTypes.ITEM, itemStack);
        if (this.level().isClientSide) {
            this.spawnBlockParticles(Blocks.GLASS_PANE.defaultBlockState(), 100);
            this.spawnBlockParticles(Blocks.SPRUCE_LOG.defaultBlockState(), 20);
            this.spawnSimpleParticles();
        }
        return particle;
    }

    private void spawnBlockParticles(BlockState state, int count) {
        BlockParticleOption particleOption = new BlockParticleOption(ParticleTypes.BLOCK, state);
        for (int i = 0; i < count; ++i) {
            this.level().addParticle((ParticleOptions)particleOption, this.getX(), this.getY(), this.getZ(), this.random.nextGaussian() * 0.02, 0.2, this.random.nextGaussian() * 0.02);
        }
    }

    private void spawnSimpleParticles() {
        for (int i = 0; i < 25; ++i) {
            double xOffset = this.random.nextGaussian() * 0.1;
            double zOffset = this.random.nextGaussian() * 0.1;
            double yOffset = this.random.nextDouble() * 0.5 + 0.2;
            this.level().addParticle((ParticleOptions)ParticleTypes.LANDING_HONEY, this.getX() + xOffset, this.getY() + yOffset, this.getZ() + zOffset, xOffset, yOffset, zOffset);
        }
    }

    public void handleEntityEvent(byte status) {
        if (status == 3) {
            ParticleOptions particleEffect = this.getParticleParameters();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particleEffect, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Entity entity = entityHitResult.getEntity();
        int damage = 2;
        entity.hurt(entity.damageSources().thrown((Entity)this, this.getOwner()), (float)damage);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.playSound(SoundEvents.WOOD_BREAK, 1.0f, 1.0f);
            BeerElementalEntity beerElemental = new BeerElementalEntity((EntityType<? extends Monster>)((EntityType)EntityTypeRegistry.BEER_ELEMENTAL.get()), this.level());
            beerElemental.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            this.level().addFreshEntity((Entity)beerElemental);
            this.discard();
        }
    }
}

