/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.model.geo;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.entity.FerretEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class FerretModel
extends GeoModel<FerretEntity> {
    private static final ResourceLocation[] MODELS = new ResourceLocation[]{CrittersAndCompanions.createId("geo/entity/ferret.geo.json"), CrittersAndCompanions.createId("geo/entity/baby_ferret.geo.json")};
    private static final ResourceLocation[] ADULT_TEXTURES = new ResourceLocation[]{CrittersAndCompanions.createId("textures/entity/ferret_1.png"), CrittersAndCompanions.createId("textures/entity/ferret_2.png")};
    private static final ResourceLocation[] BABY_TEXTURES = new ResourceLocation[]{CrittersAndCompanions.createId("textures/entity/baby_ferret_1.png"), CrittersAndCompanions.createId("textures/entity/baby_ferret_2.png")};
    private static final ResourceLocation[] ANIMATIONS = new ResourceLocation[]{CrittersAndCompanions.createId("animations/entity/ferret.animation.json"), CrittersAndCompanions.createId("animations/entity/baby_ferret.animation.json")};

    public ResourceLocation getModelResource(FerretEntity object) {
        return MODELS[object.isBaby() ? 1 : 0];
    }

    public ResourceLocation getTextureResource(FerretEntity object) {
        return object.isBaby() ? BABY_TEXTURES[object.getVariant()] : ADULT_TEXTURES[object.getVariant()];
    }

    public ResourceLocation getAnimationResource(FerretEntity animatable) {
        return ANIMATIONS[animatable.isBaby() ? 1 : 0];
    }

    public void setCustomAnimations(FerretEntity animatable, long instanceId, AnimationState<FerretEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("head");
        GeoBone neck = this.getAnimationProcessor().getBone("head_rotation");
        boolean moving = animationState.isMoving();
        if (neck != null && head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            float pitch = entityData.headPitch();
            neck.setRotX(Math.min(20.0f, pitch) * ((float)Math.PI / 180));
            if (pitch > 20.0f && !moving) {
                head.setRotX((pitch - 30.0f) * ((float)Math.PI / 180));
            }
            neck.setRotZ(entityData.netHeadYaw() * ((float)Math.PI / 180) * -0.5f);
        }
    }
}

