/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.model.geo;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.entity.RedPandaEntity;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class RedPandaModel
extends GeoModel<RedPandaEntity> {
    private static final ResourceLocation[] MODELS = new ResourceLocation[]{CrittersAndCompanions.createId("geo/entity/red_panda.geo.json"), CrittersAndCompanions.createId("geo/entity/baby_red_panda.geo.json")};
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{CrittersAndCompanions.createId("textures/entity/red_panda.png"), CrittersAndCompanions.createId("textures/entity/red_panda_sleeping.png"), CrittersAndCompanions.createId("textures/entity/baby_red_panda.png")};
    private static final ResourceLocation[] ANIMATIONS = new ResourceLocation[]{CrittersAndCompanions.createId("animations/entity/red_panda.animation.json"), CrittersAndCompanions.createId("animations/entity/baby_red_panda.animation.json")};

    public ResourceLocation getModelResource(RedPandaEntity object) {
        return MODELS[object.isBaby() ? 1 : 0];
    }

    public ResourceLocation getTextureResource(RedPandaEntity object) {
        return TEXTURES[object.isBaby() ? 2 : (object.isSleeping() ? 1 : 0)];
    }

    public ResourceLocation getAnimationResource(RedPandaEntity animatable) {
        return ANIMATIONS[animatable.isBaby() ? 1 : 0];
    }

    public void setCustomAnimations(RedPandaEntity animatable, long instanceId, AnimationState<RedPandaEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        EntityModelData data = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
        GeoBone neck = this.getAnimationProcessor().getBone("head");
        if (!animatable.isSleeping() && !animatable.isInSittingPose()) {
            if (!animatable.isAlert()) {
                neck.setRotX(data.headPitch() * ((float)Math.PI / 180));
            }
            neck.setRotY(data.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

