/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.entity.brain.SprintingFollowParentGoal;
import com.github.eterdelta.crittersandcompanions.platform.Services;
import com.github.eterdelta.crittersandcompanions.registry.CACEntities;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RedPandaEntity
extends TamableAnimal
implements GeoEntity {
    private static final TagKey<Item> TEMPT_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)CrittersAndCompanions.createId("red_panda_tempt_items"));
    private static final TagKey<Item> FOODS_TAG = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)CrittersAndCompanions.createId("red_panda_food"));
    protected static final List<EntityType<? extends Mob>> SCAREABLES = new ArrayList<EntityType>(Arrays.asList(EntityType.BEE, EntityType.ENDERMAN, EntityType.IRON_GOLEM, EntityType.LLAMA, EntityType.POLAR_BEAR, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.VEX, EntityType.WOLF, EntityType.ZOMBIFIED_PIGLIN));
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.defineId(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ALERT = SynchedEntityData.defineId(RedPandaEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private LivingEntity alerter;

    public RedPandaEntity(EntityType<? extends RedPandaEntity> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new RedPandaMoveControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 18.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SLEEPING, (Object)false);
        builder.define(ALERT, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.4));
        this.goalSelector.addGoal(2, (Goal)new AlertGoal());
        this.goalSelector.addGoal(3, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(4, (Goal)new SleepGoal(140));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(6, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(TEMPT_TAG), false));
        this.goalSelector.addGoal(7, (Goal)new SprintingFollowParentGoal(this, 1.25, 10.0f, 5.0f, 2.0f));
        this.goalSelector.addGoal(8, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(11, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Sleeping", this.isSleeping());
        compound.putBoolean("Alert", this.isAlert());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSleeping(compound.getBoolean("Sleeping"));
        this.setAlert(compound.getBoolean("Alert"));
    }

    public int getBaseExperienceReward() {
        return this.random.nextInt(2, 5);
    }

    public float getScale() {
        return this.isBaby() ? 0.6f : 1.0f;
    }

    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob ageableMob) {
        RedPandaEntity redPanda = (RedPandaEntity)((EntityType)CACEntities.RED_PANDA.get()).create((Level)level);
        return redPanda;
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        if (!this.isSleeping()) {
            ItemStack handStack = player.getItemInHand(interactionHand);
            if (!this.isTame()) {
                if (handStack.is(TEMPT_TAG)) {
                    if (!player.getAbilities().instabuild) {
                        handStack.shrink(1);
                    }
                    if (!this.level().isClientSide()) {
                        if (this.random.nextInt(10) == 0 && Services.EVENTS.canTame((Animal)this, player)) {
                            this.tame(player);
                            this.level().broadcastEntityEvent((Entity)this, (byte)7);
                        } else {
                            this.level().broadcastEntityEvent((Entity)this, (byte)6);
                        }
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
            } else if (this.isTame() && this.isOwnedBy((LivingEntity)player)) {
                if (!this.isFood(handStack) && !handStack.is(TEMPT_TAG)) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                if (this.getHealth() < this.getMaxHealth()) {
                    this.gameEvent((Holder)GameEvent.EAT, (Entity)this);
                    this.heal(2.0f);
                    if (!player.getAbilities().instabuild) {
                        handStack.shrink(1);
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
            }
            return super.mobInteract(player, interactionHand);
        }
        return InteractionResult.PASS;
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(FOODS_TAG);
    }

    protected SoundEvent getAmbientSound() {
        return this.isSleeping() ? null : (SoundEvent)CACSounds.RED_PANDA_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)CACSounds.RED_PANDA_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)CACSounds.RED_PANDA_DEATH.get();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData) {
        spawnGroupData = super.finalizeSpawn(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
        if (mobSpawnType.equals((Object)MobSpawnType.SPAWNER) && ((AgeableMob.AgeableMobGroupData)spawnGroupData).getGroupSize() >= 2 && this.random.nextFloat() <= 0.4f) {
            for (int i = 0; i < this.random.nextInt(1, 3); ++i) {
                RedPandaEntity baby = (RedPandaEntity)((EntityType)CACEntities.RED_PANDA.get()).create(this.level());
                baby.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                baby.setBaby(true);
                levelAccessor.addFreshEntity((Entity)baby);
            }
        }
        return spawnGroupData;
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.isAlert()) {
            event.getController().setAnimation(RawAnimation.begin().then("angry", Animation.LoopType.PLAY_ONCE));
        } else if (this.isInSittingPose()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sit"));
        } else if (this.isSleeping()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sleeping"));
        } else if (this.isInWater()) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("swim"));
        } else if (event.isMoving()) {
            if (this.getDeltaMovement().length() >= (double)0.16f) {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("run"));
            } else {
                event.getController().setAnimation(RawAnimation.begin().thenLoop("walk"));
            }
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 3, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isSleeping() {
        return (Boolean)this.entityData.get(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.entityData.set(SLEEPING, (Object)sleeping);
    }

    public boolean isAlert() {
        return (Boolean)this.entityData.get(ALERT);
    }

    protected void setAlert(boolean alert) {
        this.entityData.set(ALERT, (Object)alert);
    }

    static class RedPandaMoveControl
    extends MoveControl {
        private final RedPandaEntity redPanda;

        public RedPandaMoveControl(RedPandaEntity redPandaEntity) {
            super((Mob)redPandaEntity);
            this.redPanda = redPandaEntity;
        }

        public void tick() {
            if (!this.redPanda.isSleeping()) {
                super.tick();
            }
        }
    }

    public class AlertGoal
    extends Goal {
        private int time;

        public AlertGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            this.time = AlertGoal.reducedTickDelay((int)40);
        }

        public boolean canUse() {
            if (!RedPandaEntity.this.isSleeping() && !RedPandaEntity.this.isInWater()) {
                List nearAlerters = RedPandaEntity.this.level().getEntitiesOfClass(LivingEntity.class, RedPandaEntity.this.getBoundingBox().inflate(4.0), livingEntity -> RedPandaEntity.this.isTame() ? SCAREABLES.contains(livingEntity.getType()) && ((Mob)livingEntity).isAggressive() : livingEntity instanceof Player);
                LivingEntity nearestAlerter = RedPandaEntity.this.level().getNearestEntity(nearAlerters, TargetingConditions.forNonCombat().range(4.0), (LivingEntity)RedPandaEntity.this, RedPandaEntity.this.getX(), RedPandaEntity.this.getY(), RedPandaEntity.this.getZ());
                if (nearestAlerter != RedPandaEntity.this.alerter) {
                    RedPandaEntity.this.alerter = nearestAlerter;
                    return RedPandaEntity.this.alerter != null;
                }
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.time > 0;
        }

        public void start() {
            RedPandaEntity.this.setAlert(true);
            RedPandaEntity.this.getNavigation().stop();
            RedPandaEntity.this.getMoveControl().setWantedPosition(RedPandaEntity.this.getX(), RedPandaEntity.this.getY(), RedPandaEntity.this.getZ(), 0.0);
        }

        public void tick() {
            RedPandaEntity.this.getLookControl().setLookAt((Entity)RedPandaEntity.this.alerter);
            --this.time;
        }

        public void stop() {
            this.time = 20;
            RedPandaEntity.this.setAlert(false);
        }
    }

    public class SleepGoal
    extends Goal {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = RedPandaEntity.this.random.nextInt(SleepGoal.reducedTickDelay((int)countdownTime));
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public boolean canUse() {
            if (!RedPandaEntity.this.isTame() && RedPandaEntity.this.xxa == 0.0f && RedPandaEntity.this.yya == 0.0f && RedPandaEntity.this.zza == 0.0f) {
                return this.canSleep() || RedPandaEntity.this.isSleeping();
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return RedPandaEntity.this.level().isDay();
        }

        public void stop() {
            RedPandaEntity.this.setSleeping(false);
            this.countdown = RedPandaEntity.this.random.nextInt(this.countdownTime);
        }

        public void start() {
            RedPandaEntity.this.setJumping(false);
            RedPandaEntity.this.setSleeping(true);
            RedPandaEntity.this.getNavigation().stop();
            RedPandaEntity.this.getMoveControl().setWantedPosition(RedPandaEntity.this.getX(), RedPandaEntity.this.getY(), RedPandaEntity.this.getZ(), 0.0);
        }
    }
}

