/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity;

import com.github.eterdelta.crittersandcompanions.registry.CACItems;
import com.github.eterdelta.crittersandcompanions.registry.CACSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SeaBunnyEntity
extends WaterAnimal
implements Bucketable,
GeoEntity {
    private static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.defineId(SeaBunnyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.defineId(SeaBunnyEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.defineId(SeaBunnyEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected int harvestCooldown;

    public SeaBunnyEntity(EntityType<? extends SeaBunnyEntity> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new SeaBunnyMoveControl(this);
        this.jumpControl = new SeaBunnyJumpControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, 0.08);
    }

    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    public boolean removeWhenFarAway(double distance) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CLIMBING, (Object)false);
        builder.define(VARIANT, (Object)0);
        builder.define(FROM_BUCKET, (Object)false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal(this, 1.0));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Climbing", this.isClimbing());
        compound.putInt("Variant", this.getVariant());
        compound.putBoolean("FromBucket", this.fromBucket());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setClimbing(compound.getBoolean("Climbing"));
        this.setVariant(compound.getInt("Variant"));
        this.setFromBucket(compound.getBoolean("FromBucket"));
    }

    public int getBaseExperienceReward() {
        return this.random.nextInt(2, 5);
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.harvestCooldown > 0) {
            --this.harvestCooldown;
        }
    }

    public boolean fromBucket() {
        return (Boolean)this.entityData.get(FROM_BUCKET);
    }

    public void setFromBucket(boolean fromBucket) {
        this.entityData.set(FROM_BUCKET, (Object)fromBucket);
    }

    public void saveToBucketTag(ItemStack bucketStack) {
        Bucketable.saveDefaultDataToBucketTag((Mob)this, (ItemStack)bucketStack);
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucketStack, nbt -> nbt.putInt("Variant", this.getVariant()));
    }

    public void loadFromBucketTag(CompoundTag bucketCompound) {
        Bucketable.loadDefaultDataFromBucketTag((Mob)this, (CompoundTag)bucketCompound);
        this.setVariant(bucketCompound.getInt("Variant"));
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)CACItems.SEA_BUNNY_BUCKET.get());
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return (SoundEvent)CACSounds.SEA_BUNNY_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)CACSounds.SEA_BUNNY_DEATH.get();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor levelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, SpawnGroupData spawnGroupData) {
        if (mobSpawnType == MobSpawnType.BUCKET) {
            return spawnGroupData;
        }
        this.setVariant(this.random.nextInt(0, 3));
        return super.finalizeSpawn(levelAccessor, difficultyInstance, mobSpawnType, spawnGroupData);
    }

    public SoundEvent getPickupSound() {
        return SoundEvents.BUCKET_FILL_AXOLOTL;
    }

    protected PathNavigation createNavigation(Level level) {
        return new WallClimberNavigation((Mob)this, level);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            this.setClimbing(this.horizontalCollision && this.getNavigation().isInProgress());
        }
    }

    public float getWalkTargetValue(BlockPos blockPos) {
        return this.level().getBlockState(blockPos).getFluidState().isEmpty() ? 1.0f : 5.0f;
    }

    public boolean onClimbable() {
        return this.isClimbing();
    }

    public void travel(Vec3 speed) {
        super.travel(speed);
        if (this.horizontalCollision && this.onClimbable()) {
            this.setDeltaMovement(this.getDeltaMovement().subtract(0.0, 0.12, 0.0));
        }
    }

    protected InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        ItemStack handStack = player.getItemInHand(interactionHand);
        if (handStack.is(Items.BUCKET) || handStack.is(Items.WATER_BUCKET)) {
            return Bucketable.bucketMobPickup((Player)player, (InteractionHand)interactionHand, (LivingEntity)this).orElse(super.mobInteract(player, interactionHand));
        }
        if (handStack.is(Items.GLASS_BOTTLE) && this.harvestCooldown <= 0) {
            handStack.shrink(1);
            this.level().playSound(player, player.getX(), player.getY(), player.getZ(), SoundEvents.BOTTLE_FILL, SoundSource.NEUTRAL, 1.0f, 1.8f);
            if (handStack.isEmpty()) {
                player.setItemInHand(interactionHand, new ItemStack((ItemLike)CACItems.SEA_BUNNY_SLIME_BOTTLE.get()));
            } else if (!player.getInventory().add(new ItemStack((ItemLike)CACItems.SEA_BUNNY_SLIME_BOTTLE.get()))) {
                player.drop(new ItemStack((ItemLike)CACItems.SEA_BUNNY_SLIME_BOTTLE.get()), false);
            }
            this.harvestCooldown = 6000;
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return super.mobInteract(player, interactionHand);
    }

    private PlayState predicate(AnimationState<?> event) {
        if (this.getSpeed() > 0.03f) {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sea_bunny_move"));
        } else {
            event.getController().setAnimation(RawAnimation.begin().thenLoop("sea_bunny"));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isClimbing() {
        return (Boolean)this.entityData.get(CLIMBING);
    }

    public void setClimbing(boolean climbing) {
        this.entityData.set(CLIMBING, (Object)climbing);
    }

    public int getVariant() {
        return (Integer)this.entityData.get(VARIANT);
    }

    public void setVariant(int variant) {
        this.entityData.set(VARIANT, (Object)Mth.clamp((int)variant, (int)0, (int)2));
    }

    static class SeaBunnyMoveControl
    extends MoveControl {
        public SeaBunnyMoveControl(SeaBunnyEntity seaBunny) {
            super((Mob)seaBunny);
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO && !this.mob.getNavigation().isDone()) {
                double d0 = this.wantedX - this.mob.getX();
                double d2 = this.wantedZ - this.mob.getZ();
                float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), f, 90.0f));
                this.mob.yBodyRot = this.mob.getYRot();
                float speed = (float)this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED);
                speed = (float)((double)speed * (this.mob.isInWater() ? 2.0 + this.speedModifier : this.speedModifier));
                this.mob.setSpeed(speed);
            } else {
                this.mob.setSpeed(0.0f);
            }
        }
    }

    static class SeaBunnyJumpControl
    extends JumpControl {
        public SeaBunnyJumpControl(SeaBunnyEntity seaBunny) {
            super((Mob)seaBunny);
        }

        public void jump() {
        }
    }

    static class RandomStrollGoal
    extends net.minecraft.world.entity.ai.goal.RandomStrollGoal {
        public RandomStrollGoal(SeaBunnyEntity seaBunny, double speedModifier) {
            super((PathfinderMob)seaBunny, speedModifier, 20);
        }

        protected Vec3 getPosition() {
            Vec3 randomPos = RandomPos.generateRandomPos((PathfinderMob)this.mob, () -> {
                BlockPos dirPos = RandomPos.generateRandomDirection((RandomSource)this.mob.getRandom(), (int)2, (int)2);
                BlockPos dirRandomPos = RandomPos.generateRandomPosTowardDirection((PathfinderMob)this.mob, (int)2, (RandomSource)this.mob.getRandom(), (BlockPos)dirPos);
                BlockPos finalPos = RandomPos.moveUpOutOfSolid((BlockPos)dirRandomPos, (int)this.mob.level().getMaxBuildHeight(), blockPos -> GoalUtils.isSolid((PathfinderMob)this.mob, (BlockPos)blockPos));
                return this.mob.level().getBlockState(finalPos).getFluidState().isEmpty() ? null : finalPos;
            });
            return randomPos;
        }
    }
}

