/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.entity.brain;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OtterNavigation
extends AmphibiousPathNavigation {
    private static final float EPSILON = 1.0E-8f;
    private static final double PROGRESS_MIN2 = 0.12249999999999998;
    private static final int PROGRESS_TICKS = 18;
    private final Cache<BlockPos, Boolean> cache = CacheBuilder.newBuilder().maximumSize(12000L).expireAfterAccess(5L, TimeUnit.SECONDS).build();
    private Vec3 lastCheckPos = Vec3.ZERO;
    private int lastCheckTick = 0;
    private int stuckReplans = 0;
    private int jumpCooldown = 0;

    public OtterNavigation(Mob mob, Level level) {
        super(mob, level);
        this.setCanFloat(true);
    }

    protected PathFinder createPathFinder(int nodes) {
        AmphibiousNodeEvaluator evaluator = new AmphibiousNodeEvaluator(true);
        evaluator.setCanPassDoors(false);
        this.nodeEvaluator = evaluator;
        return new PathFinder(this.nodeEvaluator, nodes);
    }

    protected boolean canUpdatePath() {
        return true;
    }

    public boolean isStableDestination(BlockPos pos) {
        if (!this.level.getBlockState(pos).isAir()) {
            return super.isStableDestination(pos);
        }
        BlockState below = this.level.getBlockState(pos.below());
        if (below.isAir() && !below.getFluidState().is(FluidTags.WATER)) {
            return false;
        }
        return this.level.getBlockState(pos).isAir() && this.level.getBlockState(pos.above()).isAir();
    }

    protected void followThePath() {
        if (this.path == null || this.path.isDone()) {
            return;
        }
        Vec3 entityPos = this.getTempMobPos();
        int nextIdx = this.path.getNextNodeIndex();
        double yFloor = Math.floor(entityPos.y);
        for (int lastIdx = nextIdx; lastIdx < this.path.getNodeCount() && (double)this.path.getNode((int)lastIdx).y == yFloor; ++lastIdx) {
        }
        for (int i = lastIdx - 1; i > nextIdx; --i) {
            if (!this.catchF(entityPos, this.path.getEntityPosAtNode((Entity)this.mob, i))) continue;
            this.path.setNextNodeIndex(i);
            break;
        }
        if (this.hasReached(this.path, 0.8f) || this.isAtElevationChange(this.path) && this.hasReached(this.path, 1.0f)) {
            this.path.advance();
        }
        if (this.path.isDone()) {
            return;
        }
        Vec3 target = this.path.getNextEntityPos((Entity)this.mob);
        this.mob.getMoveControl().setWantedPosition(target.x, target.y, target.z, this.speedModifier);
        if (this.jumpCooldown > 0) {
            --this.jumpCooldown;
        }
        if (!this.mob.isInWater() && this.mob.onGround() && this.mob.horizontalCollision && this.jumpCooldown == 0) {
            Vec3 dir = new Vec3(target.x - this.mob.getX(), 0.0, target.z - this.mob.getZ());
            if (dir.lengthSqr() > 1.0E-4) {
                dir = dir.normalize();
            }
            double reach = (double)this.mob.getBbWidth() * 0.5 + 0.6;
            BlockPos front = BlockPos.containing((double)(this.mob.getX() + dir.x * reach), (double)Math.floor(this.mob.getY()), (double)(this.mob.getZ() + dir.z * reach));
            VoxelShape shape = this.level.getBlockState(front).getCollisionShape((BlockGetter)this.level, front);
            double h = shape.isEmpty() ? 0.0 : shape.max(Direction.Axis.Y);
            BlockPos head = front.above();
            boolean headClear = this.level.getBlockState(head).getCollisionShape((BlockGetter)this.level, head).isEmpty();
            boolean head2Clear = this.level.getBlockState(head.above()).getCollisionShape((BlockGetter)this.level, head.above()).isEmpty();
            if (h > 0.01 && h <= 1.2 && headClear && head2Clear) {
                this.mob.getJumpControl().jump();
                this.jumpCooldown = 6;
            } else {
                this.perpendicularSideS(dir);
            }
        }
        if (this.mob.isInWater()) {
            if (this.mob.horizontalCollision && this.damp()) {
                return;
            }
            if (this.level.getFluidState(BlockPos.containing((Position)this.mob.getEyePosition())).is(FluidTags.WATER) && target.y > entityPos.y) {
                this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.03, 0.0));
            }
            if (this.mob.onGround() && this.mob.horizontalCollision && this.jumpCooldown == 0) {
                double shadeHeight;
                BlockPos nose = this.mob.blockPosition().relative(this.mob.getDirection());
                VoxelShape shape = this.level.getBlockState(nose).getCollisionShape((BlockGetter)this.level, nose);
                double d = shadeHeight = shape.isEmpty() ? 0.0 : shape.max(Direction.Axis.Y);
                if (shadeHeight > 0.01 && shadeHeight <= 1.2 && this.level.getBlockState(nose.above()).getCollisionShape((BlockGetter)this.level, nose.above()).isEmpty() && this.level.getBlockState(nose.above(2)).getCollisionShape((BlockGetter)this.level, nose.above(2)).isEmpty()) {
                    this.mob.getJumpControl().jump();
                    this.jumpCooldown = 6;
                }
            }
        }
        if (this.mob.tickCount - this.lastCheckTick >= 18) {
            Vec3 curr = this.mob.position();
            if (curr.distanceToSqr(this.lastCheckPos) < 0.12249999999999998) {
                BlockPos targetPos = this.getTargetPos();
                if (targetPos != null) {
                    this.recomputePath();
                }
                if (++this.stuckReplans >= 3 && this.path != null && !this.path.isDone()) {
                    Vec3 dir = new Vec3(target.x - curr.x, 0.0, target.z - curr.z);
                    if (dir.lengthSqr() > 1.0E-4) {
                        dir = dir.normalize();
                    }
                    this.perpendicularSideS(dir);
                    this.stuckReplans = 0;
                }
            } else {
                this.stuckReplans = 0;
            }
            this.lastCheckPos = curr;
            this.lastCheckTick = this.mob.tickCount;
        }
    }

    private boolean hasReached(Path path, float threshold) {
        Vec3 pos = path.getNextEntityPos((Entity)this.mob);
        if (Math.abs(this.mob.getX() - pos.x) >= (double)threshold) {
            return false;
        }
        if (Math.abs(this.mob.getZ() - pos.z) >= (double)threshold) {
            return false;
        }
        return Math.abs(this.mob.getY() - pos.y) <= 1.001;
    }

    private boolean isAtElevationChange(Path path) {
        int idx = path.getNextNodeIndex();
        int end = Math.min(path.getNodeCount(), idx + Mth.ceil((float)(this.mob.getBbWidth() * 0.5f)) + 1);
        int y = path.getNode((int)idx).y;
        for (int i = idx + 1; i < end; ++i) {
            if (path.getNode((int)i).y == y) continue;
            return true;
        }
        return false;
    }

    private boolean catchF(Vec3 from, Vec3 to) {
        int stepZ;
        float tNextZ;
        float tDeltaZ;
        int stepY;
        float tNextY;
        float tDeltaY;
        int stepX;
        float tNextX;
        float tDeltaX;
        Vec3 vec = to.subtract(from);
        float maxT = (float)vec.length();
        if (maxT < 1.0E-6f) {
            return true;
        }
        float dx = (float)(vec.x / (double)maxT);
        float dy = (float)(vec.y / (double)maxT);
        float dz = (float)(vec.z / (double)maxT);
        int currentX = Mth.floor((double)from.x);
        int currentY = Mth.floor((double)from.y);
        int currentZ = Mth.floor((double)from.z);
        if (Math.abs(dx) < 1.0E-8f) {
            tDeltaX = Float.POSITIVE_INFINITY;
            tNextX = Float.POSITIVE_INFINITY;
            stepX = 0;
        } else {
            stepX = dx > 0.0f ? 1 : -1;
            float voxelBoundaryX = stepX > 0 ? (float)(Mth.floor((double)from.x) + 1) : (float)Mth.floor((double)from.x);
            tDeltaX = 1.0f / Math.abs(dx);
            tNextX = (float)(((double)voxelBoundaryX - from.x) / (double)dx);
        }
        if (Math.abs(dy) < 1.0E-8f) {
            tDeltaY = Float.POSITIVE_INFINITY;
            tNextY = Float.POSITIVE_INFINITY;
            stepY = 0;
        } else {
            stepY = dy > 0.0f ? 1 : -1;
            float voxelBoundaryY = stepY > 0 ? (float)(Mth.floor((double)from.y) + 1) : (float)Mth.floor((double)from.y);
            tDeltaY = 1.0f / Math.abs(dy);
            tNextY = (float)(((double)voxelBoundaryY - from.y) / (double)dy);
        }
        if (Math.abs(dz) < 1.0E-8f) {
            tDeltaZ = Float.POSITIVE_INFINITY;
            tNextZ = Float.POSITIVE_INFINITY;
            stepZ = 0;
        } else {
            stepZ = dz > 0.0f ? 1 : -1;
            float voxelBoundaryZ = stepZ > 0 ? (float)(Mth.floor((double)from.z) + 1) : (float)Mth.floor((double)from.z);
            tDeltaZ = 1.0f / Math.abs(dz);
            tNextZ = (float)(((double)voxelBoundaryZ - from.z) / (double)dz);
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float t = 0.0f;
        while (t <= maxT) {
            if (tNextX < tNextY) {
                if (tNextX < tNextZ) {
                    currentX += stepX;
                    t = tNextX;
                    tNextX += tDeltaX;
                } else {
                    currentZ += stepZ;
                    t = tNextZ;
                    tNextZ += tDeltaZ;
                }
            } else if (tNextY < tNextZ) {
                currentY += stepY;
                t = tNextY;
                tNextY += tDeltaY;
            } else {
                currentZ += stepZ;
                t = tNextZ;
                tNextZ += tDeltaZ;
            }
            pos.set(currentX, currentY, currentZ);
            BlockPos immutablePos = pos.immutable();
            Boolean isPathfindable = (Boolean)this.cache.getIfPresent((Object)immutablePos);
            if (isPathfindable == null) {
                BlockState blockState = this.level.getBlockState((BlockPos)pos);
                isPathfindable = blockState.isPathfindable(PathComputationType.LAND);
                this.cache.put((Object)immutablePos, (Object)isPathfindable);
            }
            if (!isPathfindable.booleanValue()) {
                return false;
            }
            PathType pathType = this.nodeEvaluator.getPathType(this.mob, (BlockPos)pos);
            float malus = this.mob.getPathfindingMalus(pathType);
            if (!(malus < 0.0f) && !(malus >= 8.0f) && pathType != PathType.DAMAGE_FIRE && pathType != PathType.DANGER_FIRE && pathType != PathType.DAMAGE_OTHER) continue;
            return false;
        }
        return true;
    }

    private void perpendicularSideS(Vec3 dirNorm) {
        double px = -dirNorm.z;
        double pz = dirNorm.x;
        double side = this.mob.getRandom().nextBoolean() ? 1.0 : -1.0;
        Vec3 curr = this.mob.position();
        BlockPos step = BlockPos.containing((double)(curr.x + px * side * 1.5), (double)curr.y, (double)(curr.z + pz * side * 1.5));
        if (this.isStableDestination(step)) {
            this.moveTo((double)step.getX() + 0.5, step.getY(), (double)step.getZ() + 0.5, 1.1);
        }
    }

    private boolean damp() {
        BlockPos currentPos = this.mob.blockPosition();
        if (!this.level.getFluidState(currentPos).is(FluidTags.WATER)) {
            return false;
        }
        for (Direction dir : new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            for (int i = 1; i <= 2; ++i) {
                BlockPos land;
                BlockPos edge = currentPos.relative(dir, i);
                if (!this.level.getFluidState(edge).is(FluidTags.WATER) || !this.level.getBlockState(edge.above()).isAir() || !this.level.getBlockState(edge.above(2)).isAir() || !this.level.getBlockState(land = edge.relative(dir)).isAir() || !this.level.getBlockState(land.below()).isSolid() || !this.isStableDestination(land)) continue;
                this.moveTo((double)land.getX() + 0.5, land.getY(), (double)land.getZ() + 0.5, Math.max(1.0, this.speedModifier));
                return true;
            }
        }
        return false;
    }
}

