/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.platform;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.platform.RegistryEntry;
import com.github.eterdelta.crittersandcompanions.platform.RegistryHelper;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ForgeRegistryHelper<T>
implements RegistryHelper<T> {
    protected final DeferredRegister<T> deferred;

    public ForgeRegistryHelper(ResourceKey<Registry<T>> key, String modid) {
        this.deferred = DeferredRegister.create(key, (String)modid);
        IEventBus modBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        if (modBus == null) {
            throw new IllegalStateException("created registry helper too late: %s for %s".formatted(key, modid));
        }
        this.deferred.register(modBus);
    }

    @Override
    public <R extends T> RegistryEntry<R> register(String id, Supplier<? extends R> creator) {
        final DeferredHolder value = this.deferred.register(id, creator);
        return new RegistryEntry<R>(this){

            @Override
            public R get() {
                return value.get();
            }

            @Override
            public ResourceKey<R> getKey() {
                return value.getKey();
            }
        };
    }

    public static class ItemHelper
    extends ForgeRegistryHelper<Item> {
        public ItemHelper(String modid) {
            super(Registries.ITEM, modid);
            IEventBus modBus = ModLoadingContext.get().getActiveContainer().getEventBus();
            modBus.addListener(event -> {
                if (event.getTab() != CrittersAndCompanions.CREATIVE_TAB.get()) {
                    return;
                }
                this.deferred.getEntries().forEach(it -> event.accept(new ItemStack((ItemLike)it.get())));
            });
        }
    }
}

