/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.satisfy.herbalbrews.core.registry.MenuTypeRegistry;
import net.satisfy.herbalbrews.core.registry.TagsRegistry;
import org.jetbrains.annotations.NotNull;

public class TeaKettleGuiHandler
extends AbstractContainerMenu {
    private final Container container;
    private final ContainerData propertyDelegate;

    public TeaKettleGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(8), (ContainerData)new SimpleContainerData(5));
    }

    public TeaKettleGuiHandler(int syncId, Inventory playerInventory, Container container, ContainerData propertyDelegate) {
        super((MenuType)MenuTypeRegistry.TEA_KETTLE_SCREEN_HANDLER.get(), syncId);
        int i;
        this.container = container;
        this.propertyDelegate = propertyDelegate;
        this.addDataSlots(this.propertyDelegate);
        this.addSlot((Slot)new FurnaceResultSlot(playerInventory.player, container, 0, 91, 22));
        this.addSlot(new Slot(container, 1, 13, 12));
        this.addSlot(new Slot(container, 2, 31, 12));
        this.addSlot(new Slot(container, 3, 13, 30));
        this.addSlot(new Slot(container, 4, 31, 30));
        this.addSlot(new Slot(this, container, 5, 31, 52){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(TagsRegistry.CONTAINER_ITEMS);
            }
        });
        this.addSlot(new Slot(this, container, 6, 118, 43){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(TagsRegistry.SMALL_WATER_FILL) || stack.is(TagsRegistry.LARGE_WATER_FILL);
            }
        });
        this.addSlot(new Slot(this, container, 7, 95, 58){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(TagsRegistry.HEAT_ITEMS);
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public boolean isBeingBurned() {
        return this.propertyDelegate.get(1) != 0;
    }

    public int getScaledProgress(int arrowWidth) {
        int progress = this.propertyDelegate.get(0);
        int total = this.propertyDelegate.get(4);
        if (total <= 0) {
            return 0;
        }
        return progress * arrowWidth / total;
    }

    public int getWaterLevel() {
        return this.propertyDelegate.get(2);
    }

    public int getHeatLevel() {
        return this.propertyDelegate.get(3);
    }

    public int getCookingTime() {
        return this.propertyDelegate.get(0);
    }

    public int getRequiredDuration() {
        return this.propertyDelegate.get(4);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack item = slot.getItem();
        ItemStack copy = item.copy();
        if (index < 8) {
            if (!this.moveItemStackTo(item, 8, this.slots.size(), true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(item, copy);
        } else if (index < this.slots.size() && (item.is(TagsRegistry.CONTAINER_ITEMS) ? !this.moveItemStackTo(item, 5, 6, false) : (item.is(TagsRegistry.HEAT_ITEMS) ? !this.moveItemStackTo(item, 7, 8, false) : (item.is(TagsRegistry.SMALL_WATER_FILL) || item.is(TagsRegistry.LARGE_WATER_FILL) ? !this.moveItemStackTo(item, 6, 7, false) : !this.moveItemStackTo(item, 0, 5, false))))) {
            return ItemStack.EMPTY;
        }
        if (item.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        slot.onTake(player, item);
        return copy;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }
}

