/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.effects;

import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DeeprushEffect
extends MobEffect {
    private static final int RADIUS = 10;

    public DeeprushEffect() {
        super(MobEffectCategory.BENEFICIAL, 65280);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isAlive()) {
            int finalAmplifier;
            Level world = player.level();
            List nearbyPlayers = world.getEntitiesOfClass(Player.class, player.getBoundingBox().inflate(10.0), this::isAffectedEntity);
            int playerCount = nearbyPlayers.size() - 1;
            if (playerCount < 0) {
                playerCount = 0;
            }
            if ((finalAmplifier = this.calculateFinalAmplifier(player.getBlockY(), playerCount)) > 0) {
                nearbyPlayers.stream().filter(p -> p.isAlive() && p != player && !p.isCreative()).forEach(p -> this.applyDigSpeedEffect((Player)p, finalAmplifier));
            }
        }
        return super.applyEffectTick(entity, amplifier);
    }

    private int calculateFinalAmplifier(int y, int playerCount) {
        int baseAmplifier = this.determineBaseAmplifierByYLevel(y);
        if (playerCount <= 0) {
            return baseAmplifier;
        }
        return Math.max(0, baseAmplifier / playerCount);
    }

    private int determineBaseAmplifierByYLevel(int y) {
        if (y >= 50) {
            return 0;
        }
        if (y >= 30) {
            return 1;
        }
        if (y >= 0) {
            return 2;
        }
        if (y >= -20) {
            return 3;
        }
        return 4;
    }

    private void applyDigSpeedEffect(Player player, int amplifier) {
        MobEffectInstance newEffect;
        MobEffectInstance currentEffect = player.getEffect(MobEffects.DIG_SPEED);
        if (this.shouldUpdateEffect(currentEffect, newEffect = new MobEffectInstance(MobEffects.DIG_SPEED, 200, amplifier, false, false, false))) {
            player.removeEffect(MobEffects.DIG_SPEED);
            player.addEffect(newEffect);
        }
    }

    private boolean shouldUpdateEffect(MobEffectInstance currentEffect, MobEffectInstance newEffect) {
        return currentEffect == null || currentEffect.getAmplifier() != newEffect.getAmplifier();
    }

    private boolean isAffectedEntity(Player player) {
        return player.isAlive() && !player.isCreative();
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int j) {
        return true;
    }
}

