/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.neoforge.event;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.neoforge.common.wrapper.BlockPosWrapper;
import fr.rakambda.fallingtree.neoforge.common.wrapper.BlockStateWrapper;
import fr.rakambda.fallingtree.neoforge.common.wrapper.ServerLevelWrapper;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.NotNull;

public class LeafBreakingListener {
    @NotNull
    private final FallingTreeCommon<Direction> mod;

    @SubscribeEvent
    public void onServerTick(ServerTickEvent.Post event) {
        this.mod.getLeafBreakingHandler().onServerTick();
    }

    @SubscribeEvent
    public void onNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            BlockState eventState = event.getState();
            BlockPos eventPos = event.getPos();
            this.mod.getLeafBreakingHandler().onBlockUpdate(new ServerLevelWrapper(level), new BlockPosWrapper(eventPos), new BlockStateWrapper(eventState), event.getNotifiedSides().stream().map(this.mod::asDirectionCompat).collect(Collectors.toSet()));
        }
    }

    @SubscribeEvent
    public void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            this.mod.getLeafBreakingHandler().onWorldUnload(new ServerLevelWrapper(serverLevel));
        }
    }

    @Generated
    public LeafBreakingListener(@NotNull FallingTreeCommon<Direction> mod) {
        if (mod == null) {
            throw new NullPointerException("mod is marked non-null but is null");
        }
        this.mod = mod;
    }
}

