/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.blocks.misc;

import com.mojang.serialization.MapCodec;
import earth.terrarium.handcrafted.common.blocks.base.SimpleBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackableJarBlock
extends SimpleBlock {
    public static final MapCodec<StackableJarBlock> CODEC = StackableJarBlock.simpleCodec(StackableJarBlock::new);
    public static final IntegerProperty JARS = IntegerProperty.create((String)"jars", (int)1, (int)3);
    public static final VoxelShape SHAPE_1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)9.0, (double)9.0);
    public static final VoxelShape SHAPE_2 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)9.0, (double)9.0);
    public static final VoxelShape SHAPE_3 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);

    public StackableJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)JARS, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return !useContext.isSecondaryUseActive() && useContext.getItemInHand().is(this.asItem()) && (Integer)state.getValue((Property)JARS) < 3 || super.canBeReplaced(state, useContext);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = switch ((Integer)state.getValue((Property)JARS)) {
            case 2 -> SHAPE_2;
            case 3 -> SHAPE_3;
            default -> SHAPE_1;
        };
        return shape.move(0.21875, 0.0, 0.21875);
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = context.getLevel().getBlockState(context.getClickedPos());
        if (state.is((Block)this)) {
            return (BlockState)state.setValue((Property)JARS, (Comparable)Integer.valueOf(Math.min(3, (Integer)state.getValue((Property)JARS) + 1)));
        }
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        BlockState placementState = super.getStateForPlacement(context);
        if (placementState == null) {
            return null;
        }
        return (BlockState)placementState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, JARS, WATERLOGGED});
    }
}

