/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.handcrafted.common.registry;

import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistries;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import earth.terrarium.handcrafted.common.blockentities.ContainerBlockEntity;
import earth.terrarium.handcrafted.common.blockentities.OvenBlockEntity;
import earth.terrarium.handcrafted.common.blocks.crockery.CrockeryBlockEntity;
import earth.terrarium.handcrafted.common.registry.ModBlocks;
import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class ModBlockEntityTypes {
    public static final ResourcefulRegistry<BlockEntityType<?>> BLOCK_ENTITY_TYPES = ResourcefulRegistries.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"handcrafted");
    public static final RegistryEntry<BlockEntityType<OvenBlockEntity>> OVEN = BLOCK_ENTITY_TYPES.register("oven", () -> ModBlockEntityTypes.createBlockEntityType(OvenBlockEntity::new, (Block)ModBlocks.OVEN.get()));
    public static final RegistryEntry<BlockEntityType<CrockeryBlockEntity>> CROCKERY = BLOCK_ENTITY_TYPES.register("crockery", () -> ModBlockEntityTypes.createBlockEntityType(CrockeryBlockEntity::new, ModBlocks.CROCKERY_COMBOS));
    public static final RegistryEntry<BlockEntityType<ContainerBlockEntity>> CONTAINER;

    public static <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(BlockEntityType.BlockEntitySupplier<E> factory, Block ... blocks) {
        return BlockEntityType.Builder.of(factory, (Block[])blocks).build(null);
    }

    public static <E extends BlockEntity> BlockEntityType<E> createBlockEntityType(BlockEntityType.BlockEntitySupplier<E> factory, ResourcefulRegistry<Block> registry) {
        return BlockEntityType.Builder.of(factory, (Block[])((Block[])registry.stream().map(RegistryEntry::get).toArray(Block[]::new))).build(null);
    }

    static {
        ArrayList entries = new ArrayList();
        entries.addAll(ModBlocks.COUNTERS.getEntries());
        entries.addAll(ModBlocks.CUPBOARDS.getEntries());
        entries.addAll(ModBlocks.DESKS.getEntries());
        entries.addAll(ModBlocks.DRAWERS.getEntries());
        entries.addAll(ModBlocks.NIGHTSTANDS.getEntries());
        entries.addAll(ModBlocks.SHELVES.getEntries());
        entries.addAll(ModBlocks.SIDE_TABLES.getEntries());
        CONTAINER = BLOCK_ENTITY_TYPES.register("container", () -> ModBlockEntityTypes.createBlockEntityType(ContainerBlockEntity::new, (Block[])entries.stream().map(RegistryEntry::get).toArray(Block[]::new)));
    }
}

