/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientEmpty;
import com.blamejared.crafttweaker.api.ingredient.type.IIngredientList;
import com.blamejared.crafttweaker.api.ingredient.type.IngredientCraftTweakerBase;
import com.blamejared.crafttweaker.api.ingredient.type.TagIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.mixin.common.access.item.AccessIngredient;
import com.blamejared.crafttweaker.platform.Services;
import java.util.Arrays;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;

public class IngredientConverter {
    public static IIngredient fromIngredient(Ingredient ingredient) {
        if (ingredient == Ingredient.EMPTY) {
            return IngredientConverter.empty();
        }
        Ingredient ingredient2 = ingredient;
        if (ingredient2 instanceof IngredientCraftTweakerBase) {
            IngredientCraftTweakerBase base = (IngredientCraftTweakerBase)ingredient2;
            return base.getCrTIngredient();
        }
        if (Services.PLATFORM.isCustomIngredient(ingredient)) {
            return new IIngredientList((IIngredient[])Services.PLATFORM.getCustomIngredientItems(ingredient).map(IItemStack::of).toArray(IIngredient[]::new));
        }
        return IngredientConverter.fromIItemLists(((AccessIngredient)ingredient).crafttweaker$getValues());
    }

    private static IIngredient fromIItemLists(Ingredient.Value ... itemLists) {
        IIngredient[] ingredients = (IIngredient[])Arrays.stream(itemLists).map(IngredientConverter::fromIItemList).filter(IngredientConverter::notEmptyStack).toArray(IIngredient[]::new);
        return IngredientConverter.mergeIngredients(ingredients);
    }

    private static IIngredient fromIItemList(Ingredient.Value value) {
        if (value instanceof Ingredient.TagValue) {
            return IngredientConverter.fromTagList((Ingredient.TagValue)value);
        }
        IIngredient[] ingredients = (IItemStack[])value.getItems().stream().filter(stack -> !stack.isEmpty()).map(IItemStack::of).toArray(IItemStack[]::new);
        return IngredientConverter.mergeIngredients(ingredients);
    }

    private static IIngredient fromTagList(Ingredient.TagValue value) {
        TagKey key = value.tag();
        return new TagIngredient((TagKey<Item>)key);
    }

    private static IIngredient empty() {
        return IIngredientEmpty.INSTANCE;
    }

    private static IIngredient mergeIngredients(IIngredient ... ingredients) {
        if (ingredients.length == 0) {
            return IngredientConverter.empty();
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        return new IIngredientList(ingredients);
    }

    private static boolean notEmptyStack(IIngredient iIngredient) {
        return !(iIngredient instanceof IItemStack) || !iIngredient.isEmpty();
    }
}

