/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.transformer.type;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.transformer.IIngredientTransformer;
import com.blamejared.crafttweaker.api.ingredient.transformer.serializer.TransformDamageSerializer;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.ingredient.transform.type.TransformDamage")
@Document(value="vanilla/api/ingredient/transform/type/TransformDamage")
public record TransformDamage(int amount) implements IIngredientTransformer
{
    @Override
    public IItemStack transform(IItemStack stack) {
        int damage = stack.getDamage();
        int newDamage = damage + this.amount();
        if (newDamage >= stack.getMaxDamage()) {
            return IItemStack.empty();
        }
        return (IItemStack)stack.copy().withDamage(newDamage);
    }

    @Override
    public String getCommandString(String base) {
        return "%s.transformDamage(%s)".formatted(base, this.amount() != 1 ? Integer.valueOf(this.amount) : "");
    }

    public TransformDamageSerializer getSerializer() {
        return TransformDamageSerializer.INSTANCE;
    }
}

