/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.item;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.condition.IngredientConditions;
import com.blamejared.crafttweaker.api.ingredient.transformer.IngredientTransformers;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStackMutable;
import com.blamejared.crafttweaker.api.item.NeoForgeItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.function.Consumer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.item.MCItemStack")
@Document(value="neoforge/api/item/MCItemStack")
public class MCItemStack
implements NeoForgeItemStack {
    private final ItemStack internal;
    private final IngredientConditions conditions;
    private final IngredientTransformers transformers;

    public MCItemStack(ItemStack internal) {
        this.internal = internal;
        this.conditions = new IngredientConditions();
        this.transformers = new IngredientTransformers();
    }

    public MCItemStack(ItemStack internal, IngredientConditions conditions, IngredientTransformers transformers) {
        this.internal = internal;
        this.conditions = conditions;
        this.transformers = transformers;
    }

    @Override
    public IItemStack[] getItems() {
        return new IItemStack[]{this.copy()};
    }

    @Override
    public IngredientTransformers transformers() {
        return this.transformers;
    }

    @Override
    public IngredientConditions conditions() {
        return this.conditions;
    }

    @Override
    public IItemStack copy() {
        return new MCItemStack(this.getImmutableInternal(), this.conditions.copy(), this.transformers.copy());
    }

    @Override
    public IItemStack asMutable() {
        if (this == IItemStack.empty() || this.getInternal() == ItemStack.EMPTY) {
            return new MCItemStackMutable(new ItemStack((ItemLike)Items.AIR));
        }
        return new MCItemStackMutable(this.getInternal(), this.conditions.copy(), this.transformers.copy());
    }

    @Override
    public IItemStack asImmutable() {
        return this;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public ItemStack getInternal() {
        return this.internal;
    }

    @Override
    public IItemStack modify(Consumer<ItemStack> stackModifier) {
        ItemStack newStack = this.getInternal().copy();
        stackModifier.accept(newStack);
        return new MCItemStack(newStack);
    }

    @Override
    public IItemStack modifyThis(Consumer<IItemStack> modifier) {
        IItemStack newStack = this.copy();
        modifier.accept(newStack);
        return newStack;
    }

    public int hashCode() {
        return ItemStack.hashItemAndComponents((ItemStack)this.getInternal());
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemStack thatStack = ((MCItemStack)o).getInternal();
        ItemStack thisStack = this.getInternal();
        return ItemStack.matches((ItemStack)thisStack, (ItemStack)thatStack);
    }

    public String toString() {
        return this.getCommandString();
    }
}

