/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.component;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.recipe.component.ListRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.component.SimpleRecipeComponent;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="vanilla/api/recipe/IRecipeComponent")
@ZenCodeType.Name(value="crafttweaker.api.recipe.IRecipeComponent")
@ZenRegister
public sealed interface IRecipeComponent<T>
extends CommandStringDisplayable
permits SimpleRecipeComponent, ListRecipeComponent {
    public static <T> IRecipeComponent<T> find(ResourceLocation id) {
        return CraftTweakerAPI.getRegistry().findRecipeComponent(id);
    }

    public static <T> IRecipeComponent<T> simple(ResourceLocation id, TypeToken<T> objectType, BiPredicate<T, T> matcher) {
        return new SimpleRecipeComponent<T>(Objects.requireNonNull(id), Objects.requireNonNull(objectType), Objects.requireNonNull(matcher));
    }

    public static <T> IRecipeComponent<T> composite(ResourceLocation id, TypeToken<T> objectType, BiPredicate<T, T> matcher, Function<T, Collection<T>> unwrappingFunction, Function<Collection<T>, T> wrapper) {
        return new ListRecipeComponent<T>(Objects.requireNonNull(id), Objects.requireNonNull(objectType), Objects.requireNonNull(matcher), Objects.requireNonNull(unwrappingFunction), Objects.requireNonNull(wrapper));
    }

    public ResourceLocation id();

    public TypeToken<T> objectType();

    public boolean match(T var1, T var2);

    public Collection<T> unwrap(T var1);

    public T wrap(Collection<T> var1);

    @Override
    default public String getCommandString() {
        return "<recipecomponent:" + String.valueOf(this.id()) + ">";
    }
}

