/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.util;

import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@Document(value="vanilla/api/util/NameUtil")
@ZenCodeType.Name(value="crafttweaker.util.NameUtil")
@ZenRegister
public final class NameUtil {
    private static final String AUTOGENERATED_MARKER = "autogenerated/";

    @ZenCodeType.Method
    public static ResourceLocation fromFixedName(String input) {
        return NameUtil.fromFixedName(input, (fix, mistakes) -> {});
    }

    @ZenCodeType.Method
    public static ResourceLocation fromFixedName(String input, BiConsumer<String, List<String>> mistakeHandler) {
        return CraftTweakerConstants.rl(NameUtil.fixing(input, mistakeHandler));
    }

    @ZenCodeType.Method
    public static String fixing(String input) {
        return NameUtil.fixing(input, (fix, mistakes) -> {});
    }

    @ZenCodeType.Method
    public static String fixing(String input, BiConsumer<String, List<String>> mistakeHandler) {
        ArrayList<Object> mistakes = new ArrayList<Object>();
        String fixed = input;
        if (fixed.indexOf(58) >= 0) {
            mistakes.add("- it cannot contain colons (':')");
            fixed = fixed.replace(':', '.');
        }
        if (fixed.indexOf(32) >= 0) {
            mistakes.add("- it cannot contain spaces");
            fixed = fixed.replace(' ', '.');
        }
        if (!fixed.toLowerCase(Locale.ENGLISH).equals(fixed)) {
            mistakes.add("- it must be all lowercase");
            fixed = fixed.toLowerCase(Locale.ENGLISH);
        }
        if (fixed.startsWith(AUTOGENERATED_MARKER)) {
            mistakes.add("- it cannot reside in the reserved 'autogenerated' subdomain");
            fixed = fixed.substring(AUTOGENERATED_MARKER.length());
        }
        try {
            CraftTweakerConstants.rl(fixed);
            if (!mistakes.isEmpty()) {
                mistakeHandler.accept(fixed, mistakes);
            }
            return fixed;
        }
        catch (IllegalArgumentException | ResourceLocationException e) {
            mistakes.add("- " + e.getMessage());
            mistakeHandler.accept("<unable to auto-fix, best attempt: " + fixed + ">", mistakes);
            throw e;
        }
    }

    @ZenCodeType.Method
    public static boolean isAutogeneratedName(ResourceLocation name) {
        return "crafttweaker".equals(name.getNamespace()) && name.getPath().startsWith(AUTOGENERATED_MARKER);
    }

    public static ResourceLocation generateNameFrom(String discriminator, String name) {
        return CraftTweakerConstants.rl(AUTOGENERATED_MARKER + discriminator + "/" + name);
    }
}

