/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.fluid;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.blamejared.crafttweaker_annotations.annotations.TaggableElement;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/fluid/Fluid")
@NativeTypeRegistration(value=Fluid.class, zenCodeName="crafttweaker.api.fluid.Fluid")
@TaggableElement(value="minecraft:fluid")
public class ExpandFluid {
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    public static IFluidStack multiply(Fluid internal, int amount) {
        return ExpandFluid.makeStack(internal, amount);
    }

    @ZenCodeType.Method
    public static IFluidStack makeStack(Fluid internal, int amount) {
        return IFluidStack.of(internal, amount);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="bucket")
    public static Item getBucket(Fluid internal) {
        return internal.getBucket();
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.EQUALS)
    public static boolean isSame(Fluid internal, Fluid other) {
        return internal.isSame(other);
    }

    @ZenCodeType.Method
    public static boolean isIn(Fluid internal, KnownTag<Fluid> tag) {
        return internal.is(tag.getTagKey());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="registryName")
    public static ResourceLocation getRegistryName(Fluid internal) {
        return BuiltInRegistries.FLUID.getKey((Object)internal);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="commandString")
    public static String getCommandString(Fluid internal) {
        return "<fluid:" + String.valueOf(BuiltInRegistries.FLUID.getKey((Object)internal)) + ">.definition";
    }
}

