/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.game;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.level.CraftTweakerSavedData;
import com.blamejared.crafttweaker.api.level.CraftTweakerSavedDataHolder;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.mojang.brigadier.ParseResults;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="vanilla/api/game/Server")
@NativeTypeRegistration(value=MinecraftServer.class, zenCodeName="crafttweaker.api.game.Server")
public class ExpandServer {
    @ZenCodeType.Getter(value="advancements")
    public static ServerAdvancementManager getAdvancements(MinecraftServer internal) {
        return internal.getAdvancements();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="playerList")
    public static PlayerList getPlayerList(MinecraftServer internal) {
        return internal.getPlayerList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="overworldData")
    public static CraftTweakerSavedData getOverworldData(MinecraftServer internal) {
        return ((CraftTweakerSavedDataHolder)internal.overworld()).crafttweaker$getSavedData();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="defaultGameTime")
    public static GameType getDefaultGameType(MinecraftServer internal) {
        return internal.getDefaultGameType();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isHardcore")
    public static boolean isHardcore(MinecraftServer internal) {
        return internal.isHardcore();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="operatorUserPermissionLevel")
    public static int getOperatorUserPermissionLevel(MinecraftServer internal) {
        return internal.getOperatorUserPermissionLevel();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isRunning")
    public static boolean isRunning(MinecraftServer internal) {
        return internal.isRunning();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isShutdown")
    public static boolean isShutdown(MinecraftServer internal) {
        return internal.isShutdown();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="overworld")
    public static ServerLevel overworld(MinecraftServer internal) {
        return internal.overworld();
    }

    @ZenCodeType.Method
    public static @ZenCodeType.Nullable ServerLevel getLevel(MinecraftServer internal, ResourceLocation location) {
        return internal.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)location));
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="levelKeys")
    public static List<ResourceLocation> levelKeys(MinecraftServer internal) {
        return internal.levelKeys().stream().map(ResourceKey::location).toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="allLevels")
    public static Iterable<ServerLevel> getAllLevels(MinecraftServer internal) {
        return internal.getAllLevels();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="serverVersion")
    public static String getServerVersion(MinecraftServer internal) {
        return internal.getServerVersion();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="playerCount")
    public static int getPlayerCount(MinecraftServer internal) {
        return internal.getPlayerCount();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="maxPlayer")
    public static int getMaxPlayers(MinecraftServer internal) {
        return internal.getMaxPlayers();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="playerNames")
    public static String[] getPlayerNames(MinecraftServer internal) {
        return internal.getPlayerNames();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="serverModName")
    public static String getServerModName(MinecraftServer internal) {
        return internal.getServerModName();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="moddeStatus")
    public static @ZenCodeType.Nullable String getModdedStatus(MinecraftServer internal) {
        return internal.getModdedStatus().fullDescription();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSingleplayer")
    public static boolean isSingleplayer(MinecraftServer internal) {
        return internal.isSingleplayer();
    }

    @ZenCodeType.Method
    public static void setDifficulty(MinecraftServer internal, Difficulty difficulty, boolean force) {
        internal.setDifficulty(difficulty, force);
    }

    @ZenCodeType.Method
    public static void setDifficultyLocked(MinecraftServer internal, boolean locked) {
        internal.setDifficultyLocked(locked);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSpawningMonsters")
    public static boolean isSpawningMonsters(MinecraftServer internal) {
        return internal.isSpawningMonsters();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isDedicatedServer")
    public static boolean isDedicatedServer(MinecraftServer internal) {
        return internal.isDedicatedServer();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isSpawningAnimals")
    public static boolean isSpawningAnimals(MinecraftServer internal) {
        return internal.isSpawningAnimals();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="areNpcsEnabled")
    public static boolean areNpcsEnabled(MinecraftServer internal) {
        return internal.areNpcsEnabled();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isPvpAllowed")
    public static boolean isPvpAllowed(MinecraftServer internal) {
        return internal.isPvpAllowed();
    }

    @ZenCodeType.Method
    public static void setPvpAllowed(MinecraftServer internal, boolean pvpAllowed) {
        internal.setPvpAllowed(pvpAllowed);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isFlightAllowed")
    public static boolean isFlightAllowed(MinecraftServer internal) {
        return internal.isFlightAllowed();
    }

    @ZenCodeType.Method
    public static void setFlightAllowed(MinecraftServer internal, boolean flightAllowed) {
        internal.setFlightAllowed(flightAllowed);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isCommandBlockEnabled")
    public static boolean isCommandBlockEnabled(MinecraftServer internal) {
        return internal.isCommandBlockEnabled();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="motd")
    public static String getMotd(MinecraftServer internal) {
        return internal.getMotd();
    }

    @ZenCodeType.Method
    public static void setMotd(MinecraftServer internal, String motd) {
        internal.setMotd(motd);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isStopped")
    public static boolean isStopped(MinecraftServer internal) {
        return internal.isStopped();
    }

    @ZenCodeType.Method
    public static void setDefaultGameType(MinecraftServer internal, GameType gameType) {
        internal.setDefaultGameType(gameType);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isReady")
    public static boolean isReady(MinecraftServer internal) {
        return internal.isReady();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="tickCount")
    public static int getTickCount(MinecraftServer internal) {
        return internal.getTickCount();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="spawnProtectionRadius")
    public static int getSpawnProtectionRadius(MinecraftServer internal) {
        return internal.getSpawnProtectionRadius();
    }

    @ZenCodeType.Method
    public static boolean isUnderSpawnProtection(MinecraftServer internal, ServerLevel level, BlockPos pos, Player player) {
        return internal.isUnderSpawnProtection(level, pos, player);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="absoluteMaxWorldSize")
    public static int getAbsoluteMaxWorldSize(MinecraftServer internal) {
        return internal.getAbsoluteMaxWorldSize();
    }

    @ZenCodeType.Method
    public static int getSpawnRadius(MinecraftServer internal, @ZenCodeType.Nullable ServerLevel level) {
        return internal.getSpawnRadius(level);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isEnforceWhitelist")
    public static boolean isEnforceWhitelist(MinecraftServer internal) {
        return internal.isEnforceWhitelist();
    }

    @ZenCodeType.Method
    public static void setEnforceWhitelist(MinecraftServer internal, boolean enforceWhitelist) {
        internal.setEnforceWhitelist(enforceWhitelist);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="currentSmoothedTickTime")
    public static float getCurrentSmoothedTickTime(MinecraftServer internal) {
        return internal.getCurrentSmoothedTickTime();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="forcedGameType")
    public static @ZenCodeType.Nullable GameType getForcedGameType(MinecraftServer internal) {
        return internal.getForcedGameType();
    }

    @ZenCodeType.Method
    public static void executeCommand(MinecraftServer internal, String command, @ZenCodeType.OptionalBoolean boolean silent) {
        CommandSourceStack source = internal.createCommandSourceStack();
        ExpandServer.executeCommandInternal(internal, command, silent ? source.withSuppressedOutput() : source);
    }

    @ZenCodeType.Method
    public static void executeCommand(MinecraftServer internal, String command, Player player, @ZenCodeType.OptionalBoolean boolean silent) {
        CommandSourceStack source = player.createCommandSourceStack();
        ExpandServer.executeCommandInternal(internal, command, silent ? source.withSuppressedOutput() : source);
    }

    private static void executeCommandInternal(MinecraftServer internal, String command, CommandSourceStack source) {
        ParseResults parsedResults = internal.getCommands().getDispatcher().parse(command, (Object)source);
        internal.getCommands().performCommand(parsedResults, command);
    }
}

