/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.natives.ingredient;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.api.fluid.IFluidStack;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.natives.ingredient.ExpandFluidIngredient;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import java.util.Arrays;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@Document(value="neoforge/api/ingredient/SizedFluidIngredient")
@NativeTypeRegistration(value=SizedFluidIngredient.class, zenCodeName="crafttweaker.neoforge.api.item.SizedFluidIngredient")
public class ExpandSizedFluidIngredient {
    @ZenCodeType.Getter(value="ingredient")
    public static FluidIngredient ingredient(SizedFluidIngredient internal) {
        return internal.ingredient();
    }

    @ZenCodeType.Getter(value="amount")
    public static int amount(SizedFluidIngredient internal) {
        return internal.amount();
    }

    @ZenCodeType.StaticExpansionMethod
    public static SizedFluidIngredient of(Fluid fluid, int amount) {
        return SizedFluidIngredient.of((Fluid)fluid, (int)amount);
    }

    @ZenCodeType.StaticExpansionMethod
    public static SizedFluidIngredient of(FluidStack stack) {
        return SizedFluidIngredient.of((FluidStack)stack);
    }

    @ZenCodeType.StaticExpansionMethod
    public static SizedFluidIngredient of(KnownTag<Fluid> tag, int amount) {
        return SizedFluidIngredient.of(tag.getTagKey(), (int)amount);
    }

    @ZenCodeType.Getter(value="fluids")
    public static IFluidStack[] getFluids(SizedFluidIngredient internal) {
        return (IFluidStack[])Arrays.stream(internal.getFluids()).map(IFluidStack::of).toArray(IFluidStack[]::new);
    }

    @ZenCodeType.Method
    public static boolean test(SizedFluidIngredient internal, IFluidStack stack) {
        return internal.test((FluidStack)stack.getInternal());
    }

    @ZenCodeType.Caster(implicit=true)
    public static CTFluidIngredient asCTFluidIngredient(SizedFluidIngredient internal) {
        return ExpandFluidIngredient.asCTFluidIngredient(internal.ingredient(), internal.amount());
    }
}

