/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.platform.client;

import com.blamejared.crafttweaker.platform.services.IClientHelper;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import org.lwjgl.glfw.GLFW;

public class NeoForgeClientHelper
implements IClientHelper {
    @Override
    public boolean isKeyDown(KeyMapping keyBinding) {
        InputConstants.Key key = keyBinding.getKey();
        int keyCode = key.getValue();
        if (keyCode != InputConstants.UNKNOWN.getValue()) {
            long windowHandle = Minecraft.getInstance().getWindow().getWindow();
            try {
                if (key.getType() == InputConstants.Type.KEYSYM) {
                    return InputConstants.isKeyDown((long)windowHandle, (int)keyCode);
                }
                if (key.getType() == InputConstants.Type.MOUSE) {
                    return GLFW.glfwGetMouseButton((long)windowHandle, (int)keyCode) == 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isKeyDownExtra(KeyMapping keyBinding) {
        if (keyBinding.isDown()) {
            return true;
        }
        if (keyBinding.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI)) {
            return this.isKeyDown(keyBinding);
        }
        return KeyModifier.isKeyCodeModifier((InputConstants.Key)keyBinding.getKey()) && this.isKeyDown(keyBinding);
    }
}

