/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses;

import com.brutalbosses.BrutalBossesClient;
import com.brutalbosses.command.CommandSpawnBoss;
import com.brutalbosses.config.CommonConfiguration;
import com.brutalbosses.event.EventHandler;
import com.brutalbosses.event.ModEventHandler;
import com.brutalbosses.network.BossCapMessage;
import com.brutalbosses.network.BossOverlayMessage;
import com.brutalbosses.network.BossTypeSyncMessage;
import com.brutalbosses.network.VanillaParticleMessage;
import com.cupboard.config.CupboardConfig;
import com.cupboard.config.ICommonConfig;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Random;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="brutalbosses")
public class BrutalBosses {
    public static final String MODID = "brutalbosses";
    public static final Logger LOGGER = LogManager.getLogger();
    public static CupboardConfig<CommonConfiguration> config = new CupboardConfig("brutalbosses", (ICommonConfig)new CommonConfiguration());
    public static Random rand = new Random();
    private final IEventBus modEventBus;

    public BrutalBosses(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.register(ModEventHandler.class);
        NeoForge.EVENT_BUS.register(EventHandler.class);
        NeoForge.EVENT_BUS.addListener(this::onCommandsRegister);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::register);
        this.modEventBus = modEventBus;
        if (FMLEnvironment.dist == Dist.CLIENT) {
            BrutalBossesClient.onInitializeClient(modEventBus);
        }
    }

    @SubscribeEvent
    public void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(BossCapMessage.TYPE, StreamCodec.of((buf, msg) -> msg.write((FriendlyByteBuf)buf), byteBuf -> new BossCapMessage().read((FriendlyByteBuf)byteBuf)), (msg, context) -> msg.handle(context.player()));
        registrar.playToClient(BossOverlayMessage.TYPE, StreamCodec.of((buf, msg) -> msg.write((FriendlyByteBuf)buf), byteBuf -> new BossOverlayMessage().read((FriendlyByteBuf)byteBuf)), (msg, context) -> msg.handle(context.player()));
        registrar.playToClient(BossTypeSyncMessage.TYPE, StreamCodec.of((buf, msg) -> msg.write((FriendlyByteBuf)buf), byteBuf -> new BossTypeSyncMessage().read((FriendlyByteBuf)byteBuf)), (msg, context) -> msg.handle(context.player()));
        registrar.playToClient(VanillaParticleMessage.TYPE, StreamCodec.of((buf, msg) -> msg.write((FriendlyByteBuf)buf), byteBuf -> new VanillaParticleMessage().read((FriendlyByteBuf)byteBuf)), (msg, context) -> msg.handle(context.player()));
    }

    private static Runnable catchErrorsFor(Runnable runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.warn("error during packet:", (Throwable)e);
            }
        };
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("brutalbosses mod initialized");
    }

    public void onCommandsRegister(RegisterCommandsEvent event) {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)MODID);
        event.getDispatcher().register((LiteralArgumentBuilder)root.then(new CommandSpawnBoss().build()));
    }
}

