/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.config.CommonConfiguration;
import com.brutalbosses.entity.BossType;
import com.brutalbosses.entity.BossTypeManager;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.cupboard.util.BlockSearch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;

public class BossSpawnHandler {
    private static ConcurrentLinkedQueue<Tuple<BlockPos, BossType>> spawns = new ConcurrentLinkedQueue();

    public static void onChestPlaced(ServerLevelAccessor world, RandomizableContainerBlockEntity chest) {
        List possibleBosses = (List)BossTypeManager.instance.lootTableSpawnEntries.get((Object)chest.lootTable.location());
        if (possibleBosses != null && !possibleBosses.isEmpty()) {
            if (BrutalBosses.rand.nextInt(100) > ((CommonConfiguration)BrutalBosses.config.getCommonConfig()).globalBossSpawnChance) {
                return;
            }
            if (BossSpawnHandler.spawnedRecentlyClose(chest.getBlockPos())) {
                return;
            }
            BossType bossType = (BossType)possibleBosses.get(BrutalBosses.rand.nextInt(possibleBosses.size()));
            if (bossType == null || bossType.getID().getPath().equals("dummyboss")) {
                return;
            }
            BossSpawnHandler.spawnBoss(world, chest.getBlockPos(), bossType, chest);
        } else if (((CommonConfiguration)BrutalBosses.config.getCommonConfig()).printChestLoottable) {
            BrutalBosses.LOGGER.info("Chest with Loottable: " + String.valueOf(chest.lootTable) + " not associated with any boss spawn");
        }
    }

    private static boolean spawnedRecentlyClose(BlockPos pos) {
        for (Tuple<BlockPos, BossType> data : spawns) {
            if (!(Math.sqrt(((BlockPos)data.getA()).distSqr((Vec3i)pos)) < (double)((CommonConfiguration)BrutalBosses.config.getCommonConfig()).minDistance)) continue;
            return true;
        }
        return false;
    }

    public static void spawnBoss(ServerLevelAccessor world, BlockPos pos, BossType bossType, RandomizableContainerBlockEntity chest) {
        try {
            BlockPos spawnPos;
            Mob boss;
            spawns.add((Tuple<BlockPos, BossType>)new Tuple((Object)pos, (Object)bossType));
            if (spawns.size() > 20) {
                spawns.poll();
            }
            if ((boss = bossType.createBossEntity((Level)world.getLevel())) == null) {
                return;
            }
            if (chest != null) {
                ResourceLocation lootTable = chest.lootTable.location();
                BrutalBosses.LOGGER.debug("Spawning " + String.valueOf(bossType.getID()) + " at " + String.valueOf(pos) + " at " + chest.getDisplayName().getString() + " with:" + String.valueOf(lootTable));
            }
            if ((spawnPos = BossSpawnHandler.findSpawnPosForBoss(world, (Entity)boss, pos)) == null) {
                boss.remove(Entity.RemovalReason.DISCARDED);
                return;
            }
            boss.setPos((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5);
            if (chest != null) {
                ((BossCapEntity)boss).getBossCap().setLootTable(chest.lootTable.location());
            }
            ((BossCapEntity)boss).getBossCap().setSpawnPos(pos);
            if (!boss.isRemoved()) {
                world.addFreshEntity((Entity)boss);
            }
        }
        catch (Exception spawnException) {
            BrutalBosses.LOGGER.error("Boss: " + String.valueOf(bossType.getID()) + " failed to spawn! Error:", (Throwable)spawnException);
        }
    }

    public static BlockPos findSpawnPosForBoss(ServerLevelAccessor world, Entity boss, BlockPos pos) {
        BlockPos spawnPos = BlockSearch.findAround((BlockGetter)world, (BlockPos)pos, (int)15, (int)10, (int)1, (w, p) -> {
            if (w.getBlockState(p.below()).isAir()) {
                return false;
            }
            for (int x = Mth.floor((float)((-boss.getBbWidth() + 1.0f) / 2.0f)); x <= Mth.ceil((float)((boss.getBbWidth() - 1.0f) / 2.0f)); ++x) {
                for (int z = Mth.floor((float)((-boss.getBbWidth() + 1.0f) / 2.0f)); z <= Mth.ceil((float)((boss.getBbWidth() - 1.0f) / 2.0f)); ++z) {
                    for (int y = 0; y <= Mth.ceil((float)boss.getBbHeight()); ++y) {
                        if (w.getBlockState(p.offset(x, y, z)).isAir()) continue;
                        return false;
                    }
                }
            }
            return true;
        });
        return spawnPos;
    }

    public static void spawnRandomBoss(ServerLevel world, BlockPos pos) {
        ArrayList<BossType> list = new ArrayList<BossType>(BossTypeManager.instance.bosses.values());
        BossType bossType = (BossType)list.get(BrutalBosses.rand.nextInt(list.size()));
        BossSpawnHandler.spawnBoss((ServerLevelAccessor)world, pos, bossType, null);
    }
}

