/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class ChasingGoal
extends Goal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:chasetarget");
    private final Mob mob;
    private float chaseDist;
    private LivingEntity target = null;
    private final ChaseParams params;
    private int ticksToNextUpdate = 0;

    public ChasingGoal(Mob mob, IAIParams params) {
        this.params = (ChaseParams)params;
        this.chaseDist = this.params.chasedistance * this.params.chasedistance;
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        if (target != null && target.isAlive()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void stop() {
        this.target = null;
    }

    public void tick() {
        this.mob.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ());
        if (--this.ticksToNextUpdate > 0) {
            return;
        }
        double distSqr = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        this.ticksToNextUpdate = (int)Math.max(4.0, distSqr / 100.0);
        if (distSqr <= (double)this.chaseDist && this.mob.getSensing().hasLineOfSight((Entity)this.target)) {
            this.mob.getNavigation().stop();
        } else {
            Path path = this.mob.getNavigation().getPath();
            if (path != null) {
                BlockPos endPos;
                double endPosDist;
                Node endNode = path.getEndNode();
                if (endNode != null && ((endPosDist = this.target.distanceToSqr((double)(endPos = new BlockPos(endNode.x, endNode.y, endNode.z)).getX(), (double)endPos.getY(), (double)endPos.getZ())) > (double)this.chaseDist || !this.mob.getSensing().hasLineOfSight((Entity)this.target))) {
                    this.mob.getNavigation().moveTo((Entity)this.target, 1.0);
                }
            } else {
                this.mob.getNavigation().moveTo((Entity)this.target, 1.0);
            }
        }
    }

    public static class ChaseParams
    extends IAIParams.DefaultParams {
        private float chasedistance = 2.0f;
        private static final String CHASE_DIST = "chasedistance";

        public ChaseParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(CHASE_DIST)) {
                this.chasedistance = jsonElement.get(CHASE_DIST).getAsFloat();
            }
            return this;
        }
    }
}

