/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class CommandRunGoal
extends Goal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:runcommand");
    private final Mob mob;
    private CommandParams params;
    private LivingEntity target = null;
    private int cooldown = 0;
    private int combatTimer = 0;

    public CommandRunGoal(Mob mob, IAIParams params) {
        this.params = (CommandParams)params;
        this.mob = mob;
    }

    public boolean canUse() {
        LivingEntity target;
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.combatTimer > 0) {
            --this.combatTimer;
        }
        if ((target = this.mob.getTarget()) != null && target.isAlive()) {
            this.combatTimer = 600;
            if (this.cooldown > 0) {
                return false;
            }
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        if (this.combatTimer == 0) {
            this.cooldown = 0;
        }
        return false;
    }

    public void start() {
        this.cooldown = this.params.cooldown;
        try {
            this.mob.level().getServer().getCommands().getDispatcher().execute(this.params.command, (Object)new CommandSourceStack((CommandSource)this.mob, this.mob.position(), this.mob.getRotationVector(), (ServerLevel)this.mob.level(), 4, "Server", (Component)Component.literal((String)"brutalbosses:aicommand"), this.mob.level().getServer(), null).withEntity((Entity)this.mob));
        }
        catch (CommandSyntaxException e) {
            BrutalBosses.LOGGER.warn("Failed to run ai command: " + this.params.command, (Throwable)e);
        }
    }

    public void tick() {
    }

    public static class CommandParams
    extends IAIParams.DefaultParams {
        private String command;
        private int cooldown;
        private static final String COOLDOWN = "cooldown";
        public static final String COMMAND = "command";

        public CommandParams(JsonObject jsonData) {
            super(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            this.command = "";
            if (jsonElement.has(COMMAND)) {
                this.command = jsonElement.get(COMMAND).getAsString();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.cooldown = jsonElement.get(COOLDOWN).getAsInt();
            }
            return this;
        }
    }
}

