/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.config.CommonConfiguration;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import com.brutalbosses.entity.thrownentity.ThrownItemEntity;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;

public class ItemThrowAttackGoal
extends SimpleRangedAttackGoal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:itemshootgoal");

    public ItemThrowAttackGoal(Mob mob, IAIParams params) {
        super(mob, params);
    }

    @Override
    protected ResourceLocation getID() {
        return ID;
    }

    @Override
    protected void doRangedAttack(Projectile Projectile2, LivingEntity target) {
        Projectile2.remove(Entity.RemovalReason.DISCARDED);
        double xDiff = target.getX() - this.mob.getX();
        double yDiff = target.getY(0.5) - (this.mob.getY() + (double)this.mob.getEyeHeight() - 0.5);
        double zDiff = target.getZ() - this.mob.getZ();
        ThrownItemEntity pearlEntity = new ThrownItemEntity(this.mob.level(), this.mob);
        pearlEntity.setPos(this.mob.getX(), this.mob.getY() + (double)this.mob.getEyeHeight() - 0.5, this.mob.getZ());
        pearlEntity.shoot(xDiff, yDiff, zDiff, 0.8f * this.params.speed, 3.0f);
        pearlEntity.setItem(((ItemThrowParams)this.params).item);
        pearlEntity.setNoGravity(true);
        if (pearlEntity instanceof IOnProjectileHit) {
            ((IOnProjectileHit)((Object)pearlEntity)).setMaxLifeTime(this.mob.level().getGameTime() + 400L);
            ((IOnProjectileHit)((Object)pearlEntity)).setOnHitAction(rayTraceResult -> {
                if (!this.mob.isAlive()) {
                    return;
                }
                if (rayTraceResult instanceof EntityHitResult) {
                    Entity hitEntity = ((EntityHitResult)rayTraceResult).getEntity();
                    if (hitEntity instanceof LivingEntity && hitEntity != this.mob) {
                        if (((ItemThrowParams)this.params).damage > 0.0f) {
                            hitEntity.hurt(this.mob.damageSources().indirectMagic(hitEntity, (Entity)this.mob), ((ItemThrowParams)this.params).damage);
                        }
                        if (((ItemThrowParams)this.params).lighting) {
                            LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(hitEntity.level());
                            lightningboltentity.moveTo(hitEntity.getX(), hitEntity.getY(), hitEntity.getZ());
                            lightningboltentity.setVisualOnly(false);
                            this.mob.level().addFreshEntity((Entity)lightningboltentity);
                        }
                        if (((ItemThrowParams)this.params).explode) {
                            hitEntity.level().explode(null, this.mob.damageSources().indirectMagic((Entity)((LivingEntity)hitEntity), (Entity)this.mob), null, hitEntity.getX(), hitEntity.getY(), hitEntity.getZ(), (float)(1.0 * ((CommonConfiguration)BrutalBosses.config.getCommonConfig()).damageMultiplier) * pearlEntity.getScale(), false, Level.ExplosionInteraction.MOB);
                        }
                        if (((ItemThrowParams)this.params).teleport) {
                            double d0 = -Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
                            double d1 = Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
                            if (this.mob.level() instanceof ServerLevel) {
                                ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.mob.getX() + d0, this.mob.getY(0.5), this.mob.getZ() + d1, 20, d0, 0.0, d1, 0.0);
                            }
                            this.mob.level().playSound((Player)null, this.mob.xo, this.mob.yo, this.mob.zo, SoundEvents.ENDERMAN_TELEPORT, this.mob.getSoundSource(), 1.0f, 1.0f);
                            this.mob.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                            this.mob.teleportTo(pearlEntity.getX(), hitEntity.getY(), pearlEntity.getZ());
                        }
                    }
                } else if (rayTraceResult instanceof BlockHitResult) {
                    BlockPos tpPos;
                    BlockPos hitPos = ((BlockHitResult)rayTraceResult).getBlockPos();
                    if (((ItemThrowParams)this.params).lighting) {
                        LightningBolt lightningboltentity = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.mob.level());
                        lightningboltentity.moveTo((double)hitPos.getX(), (double)hitPos.getY(), (double)hitPos.getZ());
                        lightningboltentity.setVisualOnly(false);
                        this.mob.level().addFreshEntity((Entity)lightningboltentity);
                    }
                    if (((ItemThrowParams)this.params).explode) {
                        this.mob.level().explode(null, this.mob.damageSources().indirectMagic((Entity)this.mob, (Entity)this.mob), null, (double)hitPos.getX(), (double)hitPos.getY(), (double)hitPos.getZ(), (float)(1.0 * ((CommonConfiguration)BrutalBosses.config.getCommonConfig()).damageMultiplier), false, Level.ExplosionInteraction.MOB);
                    }
                    if (((ItemThrowParams)this.params).teleport && (tpPos = BossSpawnHandler.findSpawnPosForBoss((ServerLevelAccessor)((ServerLevel)this.mob.level()), (Entity)this.mob, hitPos)) != null) {
                        double d0 = -Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
                        double d1 = Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
                        if (this.mob.level() instanceof ServerLevel) {
                            ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.PORTAL, this.mob.getX() + d0, this.mob.getY(0.5), this.mob.getZ() + d1, 20, d0, 0.0, d1, 0.0);
                        }
                        this.mob.level().playSound((Player)null, this.mob.xo, this.mob.yo, this.mob.zo, SoundEvents.ENDERMAN_TELEPORT, this.mob.getSoundSource(), 1.0f, 1.0f);
                        this.mob.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                        this.mob.teleportTo((double)tpPos.getX(), (double)tpPos.getY(), (double)tpPos.getZ());
                    }
                }
            });
        }
        this.mob.level().addFreshEntity((Entity)pearlEntity);
    }

    @Override
    protected Projectile createProjectile() {
        ThrownItemEntity pearlEntity = new ThrownItemEntity(this.mob.level(), this.mob);
        pearlEntity.setItem(((ItemThrowParams)this.params).item);
        pearlEntity.setScale(((ItemThrowParams)this.params).projectilesize);
        return pearlEntity;
    }

    public static class ItemThrowParams
    extends SimpleRangedAttackGoal.RangedParams {
        private ItemStack item = Items.ENDER_PEARL.getDefaultInstance();
        private float damage = 0.0f;
        private boolean teleport = false;
        private boolean lighting = false;
        private boolean explode = false;
        private float projectilesize = 1.0f;
        private static final String ITEM = "item";
        private static final String DAMAGE = "damage";
        private static final String TELEPORT = "teleport";
        private static final String LIGHTNING = "lightning";
        private static final String EXPLODE = "explode";
        private static final String PR_SIZE = "projectilesize";

        public ItemThrowParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ITEM)) {
                try {
                    this.item = (ItemStack)ItemStack.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)TagParser.parseTag((String)jsonElement.get(ITEM).getAsString())).getOrThrow();
                }
                catch (CommandSyntaxException e) {
                    BrutalBosses.LOGGER.warn("Could not parse item of: " + jsonElement.get(ITEM).getAsString(), (Throwable)e);
                }
            }
            if (jsonElement.has(DAMAGE)) {
                this.damage = jsonElement.get(DAMAGE).getAsFloat();
            }
            if (jsonElement.has(TELEPORT)) {
                this.teleport = jsonElement.get(TELEPORT).getAsBoolean();
            }
            if (jsonElement.has(LIGHTNING)) {
                this.lighting = jsonElement.get(LIGHTNING).getAsBoolean();
            }
            if (jsonElement.has(EXPLODE)) {
                this.explode = jsonElement.get(EXPLODE).getAsBoolean();
            }
            if (jsonElement.has(PR_SIZE)) {
                this.projectilesize = jsonElement.get(PR_SIZE).getAsFloat();
            }
            return this;
        }
    }
}

