/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.data.PotionData;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class JumpAttackGoal
extends Goal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:jumpattack");
    private final Mob mob;
    private JumpAttackParams params;
    private LivingEntity target = null;
    private Vec3 end;
    private int animationTick = 0;
    private double distance = 10.0;
    private int ticksToNextUpdate = 0;
    private boolean isCharging = false;

    public JumpAttackGoal(Mob mob, IAIParams params) {
        this.params = (JumpAttackParams)params;
        this.mob = mob;
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        if (target != null && target.isAlive()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void stop() {
        this.target = null;
    }

    public void tick() {
        Path path;
        if (--this.ticksToNextUpdate > 0) {
            this.mob.setShiftKeyDown(true);
            return;
        }
        double dist = Math.sqrt(this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ()));
        if (dist >= (double)this.params.minDistance && dist <= (double)this.params.maxDistance && !this.isCharging && this.mob.getSensing().hasLineOfSight((Entity)this.target) && (float)Math.abs(this.mob.getBlockY() - this.target.getBlockY()) < this.params.maxJumpHeight && (path = this.mob.getNavigation().getPath()) != null) {
            this.isCharging = true;
            this.end = this.target.position();
            this.distance = this.mob.position().distanceTo(this.end);
            this.animationTick = 0;
            this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.FIRECHARGE_USE, this.mob.getSoundSource(), 2.0f, 1.0f);
            this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, this.mob.getSoundSource(), 1.5f, 1.0f);
            this.mob.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 100, 1));
            double d0 = -Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            double d1 = Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            if (this.mob.level() instanceof ServerLevel) {
                ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.POOF, this.mob.getX() + d0, this.mob.getY(0.5), this.mob.getZ() + d1, 30, d0, 0.0, d1, 0.0);
                ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.GLOW, this.mob.getX() + d0, this.mob.getY(0.5), this.mob.getZ() + d1, 500, d0, 0.1, d1, 10.0);
            }
        }
        if (!this.isCharging) {
            return;
        }
        this.params.duration = 20;
        this.mob.getLookControl().setLookAt((Entity)this.target);
        this.mob.getLookControl().tick();
        if ((double)this.animationTick <= (double)this.params.duration * 0.1) {
            double distanceModifier = this.distance / (double)this.params.duration;
            direction = this.end.subtract(this.mob.position()).multiply(1.0, 0.0, 1.0).normalize().multiply(distanceModifier, 1.0, distanceModifier);
            this.mob.setDeltaMovement(direction);
            this.mob.setShiftKeyDown(true);
        } else if ((double)this.animationTick <= (double)this.params.duration * 0.1 + 4.0) {
            this.mob.setJumping(true);
            this.mob.setShiftKeyDown(false);
            this.mob.getJumpControl().jump();
            double distanceModifier = this.distance / (double)this.params.duration;
            direction = this.end.subtract(this.mob.position()).multiply(1.0, 0.0, 1.0).normalize().add(0.0, 0.75, 0.0).multiply(distanceModifier, distanceModifier, distanceModifier);
            this.mob.setDeltaMovement(direction);
        } else if (this.animationTick <= this.params.duration && this.mob.position().distanceTo(this.end) >= 2.0) {
            double distanceModifier = this.distance / (double)this.params.duration;
            direction = this.end.subtract(this.mob.position()).multiply(1.0, 1.0, 1.0).normalize().multiply(distanceModifier, distanceModifier, distanceModifier);
            this.mob.setDeltaMovement(direction);
        }
        if (this.mob.onGround() && this.mob.position().distanceTo(this.end) < 2.0 || this.animationTick == this.params.duration) {
            this.isCharging = false;
            this.ticksToNextUpdate = (int)(this.params.interval + (float)(BrutalBosses.rand.nextInt(20) - 10));
            this.ticksToNextUpdate = 100;
            this.mob.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 30, 3));
            this.mob.setDeltaMovement(Vec3.ZERO.add(0.0, -0.8, 0.0));
            this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.ANVIL_LAND, this.mob.getSoundSource(), 100.0f, 0.1f);
            this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.IRON_GOLEM_DAMAGE, this.mob.getSoundSource(), 100.0f, 0.1f);
            double d0 = 3.0;
            double d1 = 3.0;
            if (this.mob.level() instanceof ServerLevel) {
                ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, this.mob.getX() + d0, this.mob.getY(), this.mob.getZ() + d1, 300, d0, 0.0, d1, 0.0);
                ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.mob.getX() + d0, this.mob.getY(), this.mob.getZ() + d1, 300, d0, 0.0, d1, 0.0);
                ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.FIREWORK, this.mob.getX() + d0, this.mob.getY(), this.mob.getZ() + d1, 300, d0, 0.0, d1, 0.0);
                ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, this.mob.getX() + d0, this.mob.getY(), this.mob.getZ() + d1, 300, d0, 0.0, d1, 0.0);
            }
            if (this.mob.distanceTo((Entity)this.target) <= this.params.attackDistance) {
                this.mob.swing(InteractionHand.MAIN_HAND);
                float damage = this.params.extraDamage;
                if (this.mob.getAttributes().hasAttribute(Attributes.ATTACK_DAMAGE)) {
                    damage = (float)((double)damage + this.mob.getAttributeValue(Attributes.ATTACK_DAMAGE));
                }
                this.target.hurt(this.mob.damageSources().mobAttack((LivingEntity)this.mob), damage);
            }
            for (PotionData potionData : this.params.potions) {
                AreaEffectCloud areaeffectcloudentity = new AreaEffectCloud(this.mob.level(), this.mob.getX(), this.mob.getY(), this.mob.getZ());
                areaeffectcloudentity.setOwner((LivingEntity)this.mob);
                areaeffectcloudentity.setParticle((ParticleOptions)(potionData.particleType() instanceof ParticleOptions ? (ParticleOptions)potionData.particleType() : ParticleTypes.SOUL_FIRE_FLAME));
                areaeffectcloudentity.setRadius((float)this.params.potionRadius);
                areaeffectcloudentity.setDuration(200);
                areaeffectcloudentity.addEffect(new MobEffectInstance(potionData.effect(), potionData.duration(), potionData.amplifier()));
                this.mob.level().addFreshEntity((Entity)areaeffectcloudentity);
            }
        } else if (this.mob.level() instanceof ServerLevel) {
            ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, this.mob.getX(), this.mob.getY(0.5), this.mob.getZ(), 10, 0.1, 0.0, 0.1, 0.05);
        }
        ++this.animationTick;
    }

    public static class JumpAttackParams
    extends IAIParams.DefaultParams {
        private float maxDistance = 15.0f;
        private float minDistance = 3.0f;
        private float maxJumpHeight = 4.0f;
        private int duration = 10;
        private float interval = 200.0f;
        private float extraDamage = 2.0f;
        private float attackDistance = 4.0f;
        private List<PotionData> potions = new ArrayList<PotionData>();
        private int potionRadius = 5;
        private static final String ATKDIST = "attackdist";
        private static final String MAXHEIGHT = "maxheight";
        private static final String EXTDMG = "extradamage";
        public static final String MINDIST = "mindist";
        public static final String MAXDIST = "maxdist";
        public static final String DURATION = "duration";
        public static final String COOLDOWN = "interval";
        public static final String POTIONS = "potions";
        public static final String POTIONRADIUS = "potionradius";
        public static final String POTIONDURATION = "duration";
        public static final String POTIONAMPLIFIER = "amplifier";
        public static final String POTIONPARTICLE = "particle";

        public JumpAttackParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ATKDIST)) {
                this.attackDistance = jsonElement.get(ATKDIST).getAsFloat();
            }
            if (jsonElement.has(EXTDMG)) {
                this.extraDamage = jsonElement.get(EXTDMG).getAsFloat();
            }
            if (jsonElement.has(MINDIST)) {
                this.minDistance = jsonElement.get(MINDIST).getAsFloat();
            }
            if (jsonElement.has(MAXDIST)) {
                this.maxDistance = jsonElement.get(MAXDIST).getAsFloat();
            }
            if (jsonElement.has("duration")) {
                this.duration = jsonElement.get("duration").getAsInt();
            }
            if (jsonElement.has(POTIONRADIUS)) {
                this.potionRadius = jsonElement.get(POTIONRADIUS).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.interval = jsonElement.get(COOLDOWN).getAsFloat();
            }
            if (jsonElement.has(MAXHEIGHT)) {
                this.maxJumpHeight = jsonElement.get(MAXHEIGHT).getAsFloat();
            }
            if (jsonElement.has(POTIONS)) {
                this.potions = new ArrayList<PotionData>();
                for (Map.Entry data : jsonElement.get(POTIONS).getAsJsonObject().entrySet()) {
                    JsonObject potionData = ((JsonElement)data.getValue()).getAsJsonObject();
                    ParticleType particleType = null;
                    if (potionData.has(POTIONPARTICLE)) {
                        particleType = (ParticleType)BuiltInRegistries.PARTICLE_TYPE.get(ResourceLocation.tryParse((String)potionData.get(POTIONPARTICLE).getAsString()));
                    }
                    this.potions.add(new PotionData((Holder<MobEffect>)((Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceLocation.tryParse((String)((String)data.getKey()))).get()), potionData.get("duration").getAsInt(), potionData.get(POTIONAMPLIFIER).getAsInt(), particleType));
                }
            }
            return this;
        }
    }
}

