/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ServerLevelAccessor;

public class LavaRescueGoal
extends Goal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:lavarescue");
    int inLavaTicks = 0;
    int counter = 0;
    private Mob entity;

    public LavaRescueGoal(Mob entity) {
        this.entity = entity;
    }

    public boolean canUse() {
        if (this.counter++ == 20) {
            this.counter = 0;
            this.inLavaTicks = this.entity.isInLava() ? ++this.inLavaTicks : 0;
            if (this.inLavaTicks > 20) {
                BlockPos tpPos;
                this.inLavaTicks = 0;
                if (this.entity.getTarget() != null) {
                    tpPos = this.entity.getTarget().blockPosition();
                } else {
                    BossCapability cap;
                    tpPos = BossSpawnHandler.findSpawnPosForBoss((ServerLevelAccessor)((ServerLevel)this.entity.level()), (Entity)this.entity, this.entity.blockPosition());
                    if (tpPos == null && (cap = ((BossCapEntity)this.entity).getBossCap()) != null) {
                        tpPos = BossSpawnHandler.findSpawnPosForBoss((ServerLevelAccessor)((ServerLevel)this.entity.level()), (Entity)this.entity, cap.getSpawnPos());
                    }
                }
                if (tpPos == null) {
                    this.entity.remove(Entity.RemovalReason.DISCARDED);
                } else {
                    this.entity.teleportTo((double)tpPos.getX(), (double)tpPos.getY(), (double)tpPos.getZ());
                }
            }
        }
        return false;
    }
}

