/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class MeleeHitGoal
extends Goal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:meleehit");
    private final Mob mob;
    private LivingEntity target = null;
    private MeleeHitParams params;
    private int attackTimer = 0;

    public MeleeHitGoal(Mob mob, IAIParams params) {
        this.params = (MeleeHitParams)params;
        this.mob = mob;
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        if (target != null && target.isAlive()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void stop() {
        this.target = null;
        this.attackTimer = 0;
    }

    public void tick() {
        if (--this.attackTimer > 0) {
            return;
        }
        double distSqr = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        if (distSqr < (double)this.params.attackDistance) {
            this.attackTimer = (int)((double)this.params.cooldown * ((double)BrutalBosses.rand.nextFloat() * 0.5 + 0.75));
            this.mob.swing(InteractionHand.MAIN_HAND);
            float damage = this.params.extraDamage;
            if (this.mob.getAttributes().hasAttribute(Attributes.ATTACK_DAMAGE)) {
                damage = (float)((double)damage + this.mob.getAttributeValue(Attributes.ATTACK_DAMAGE));
            }
            damage += EnchantmentHelper.modifyDamage((ServerLevel)((ServerLevel)this.mob.level()), (ItemStack)this.mob.getMainHandItem(), (Entity)this.target, (DamageSource)this.mob.damageSources().mobAttack((LivingEntity)this.mob), (float)damage);
            if (this.target.hurt(this.mob.damageSources().mobAttack((LivingEntity)this.mob), damage)) {
                Level level;
                if (this.params.onHitMobEffect != null) {
                    this.target.addEffect(new MobEffectInstance(this.params.onHitMobEffect, this.params.potionduration, this.params.potionlevel));
                }
                float knockBack = this.params.knockback;
                if (this.mob.getAttributes().hasAttribute(Attributes.ATTACK_KNOCKBACK)) {
                    knockBack += (float)this.mob.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
                }
                if ((knockBack = EnchantmentHelper.modifyKnockback((ServerLevel)((ServerLevel)this.mob.level()), (ItemStack)this.mob.getMainHandItem(), (Entity)this.target, (DamageSource)this.mob.damageSources().mobAttack((LivingEntity)this.mob), (float)knockBack)) > 0.0f) {
                    this.target.knockback((double)(knockBack * 0.5f), (double)Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)))));
                }
                if ((level = this.mob.level()) instanceof ServerLevel) {
                    ServerLevel serverlevel1 = (ServerLevel)level;
                    EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel1, (Entity)this.target, (DamageSource)this.mob.damageSources().mobAttack((LivingEntity)this.mob));
                }
                this.mob.setLastHurtMob((Entity)this.target);
            }
        }
    }

    public static class MeleeHitParams
    extends IAIParams.DefaultParams {
        private float attackDistance = 2.0f;
        private float extraDamage = 2.0f;
        private Holder<MobEffect> onHitMobEffect = null;
        private float knockback = 0.0f;
        private int cooldown = 30;
        private int potionlevel = 1;
        private int potionduration = 60;
        private static final String ATKDIST = "attackdist";
        private static final String EXTDMG = "damage";
        private static final String POTION = "potiononhit";
        private static final String POTION_STR = "potionlevel";
        private static final String POTION_DUR = "potionduration";
        private static final String KNOCK = "knockback";
        private static final String COOLDOWN = "cooldown";

        public MeleeHitParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ATKDIST)) {
                this.attackDistance = jsonElement.get(ATKDIST).getAsFloat();
                this.attackDistance *= this.attackDistance;
            }
            if (jsonElement.has(EXTDMG)) {
                this.extraDamage = jsonElement.get(EXTDMG).getAsFloat();
            }
            if (jsonElement.has(POTION_STR)) {
                this.potionlevel = jsonElement.get(POTION_STR).getAsInt();
            }
            if (jsonElement.has(POTION_DUR)) {
                this.potionduration = jsonElement.get(POTION_DUR).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.cooldown = jsonElement.get(COOLDOWN).getAsInt();
            }
            if (jsonElement.has(KNOCK)) {
                this.knockback = jsonElement.get(KNOCK).getAsFloat();
            }
            if (jsonElement.has(POTION)) {
                ResourceLocation MobEffectID = ResourceLocation.tryParse((String)jsonElement.get(POTION).getAsString());
                this.onHitMobEffect = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(MobEffectID).get();
            }
            return this;
        }
    }
}

