/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.PosUtil;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;

public abstract class SimpleRangedAttackGoal
extends Goal {
    protected final Mob mob;
    protected LivingEntity target;
    protected int attackTime = -1;
    protected double speedModifier;
    protected int seeTime;
    protected int attackIntervalMin;
    protected int attackIntervalMax;
    protected float attackRadiusSqr;
    protected final BossCapability cap;
    protected final RangedParams params;
    private final List<Projectile> projectileEntities = new ArrayList<Projectile>();
    private boolean isChargingUp = false;
    private final TargetingConditions playerAoeFinder;

    public SimpleRangedAttackGoal(Mob mob, IAIParams params) {
        this.mob = mob;
        this.cap = ((BossCapEntity)mob).getBossCap();
        this.params = (RangedParams)params;
        this.speedModifier = 1.0;
        this.attackIntervalMin = this.params.interval - 10;
        this.attackIntervalMax = this.params.interval + 10;
        this.attackRadiusSqr = this.params.distance * this.params.distance;
        this.playerAoeFinder = TargetingConditions.forCombat().range((double)this.params.distance);
        this.attackTime = ((RangedParams)params).interval / 2;
    }

    protected abstract ResourceLocation getID();

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        if (target != null && target.isAlive()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        target = this.mob.getLastHurtByMob();
        if (target != null && target.isAlive()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void stop() {
        this.target = null;
        this.seeTime = 0;
        for (Projectile Projectile2 : this.projectileEntities) {
            Projectile2.remove(Entity.RemovalReason.DISCARDED);
        }
        this.projectileEntities.clear();
        this.attackTime = this.params.interval / 2;
    }

    public void tick() {
        double distSqr = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        boolean canSee = this.mob.getSensing().hasLineOfSight((Entity)this.target);
        this.seeTime = canSee ? ++this.seeTime : 0;
        this.mob.getLookControl().setLookAt((Entity)this.target, 30.0f, 30.0f);
        if (!this.projectileEntities.isEmpty()) {
            for (int i = 0; i < this.projectileEntities.size(); ++i) {
                Projectile Projectile2 = this.projectileEntities.get(i);
                if (Projectile2 == null) continue;
                if (!Projectile2.isAlive()) {
                    this.projectileEntities.remove(i);
                    --i;
                    continue;
                }
                this.positionProjectile(Projectile2, i + 1);
            }
        }
        if (--this.attackTime == 0) {
            Player closest;
            if (!canSee || distSqr > (double)this.attackRadiusSqr + 2.0) {
                this.attackTime = 10;
                return;
            }
            if (this.projectileEntities.isEmpty()) {
                this.isChargingUp = true;
            }
            if (this.isChargingUp && this.projectileEntities.size() < this.params.count) {
                this.mob.getNavigation().stop();
                int nextCount = this.projectileEntities.size() + 1;
                this.projectileEntities.add(this.createProjectile(nextCount));
                if (this.params.count > 1) {
                    this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.FIRECHARGE_USE, this.mob.getSoundSource(), 0.3f, 2.0f);
                }
                if (nextCount == this.params.count) {
                    if (this.mob instanceof SpellcasterIllager) {
                        ((SpellcasterIllager)this.mob).setIsCastingSpell(SpellcasterIllager.IllagerSpell.NONE);
                    }
                    this.isChargingUp = false;
                    this.attackTime = 5 * this.params.count;
                } else {
                    if (this.mob instanceof SpellcasterIllager) {
                        ((SpellcasterIllager)this.mob).setIsCastingSpell(SpellcasterIllager.IllagerSpell.WOLOLO);
                    }
                    this.attackTime = 5;
                }
                return;
            }
            if (this.params.count > 1 && this.projectileEntities.size() % 2 == 0 && (closest = this.mob.level().getNearestPlayer((Entity)this.mob, (double)this.params.distance)) != null) {
                this.target = closest;
            }
            Projectile Projectile3 = this.projectileEntities.remove(this.projectileEntities.size() - 1);
            if (this.params.aoe) {
                Projectile3.remove(Entity.RemovalReason.DISCARDED);
                List players = this.mob.level().getNearbyEntities(Player.class, this.playerAoeFinder, (LivingEntity)this.mob, this.mob.getBoundingBox().inflate((double)this.params.distance, 15.0, (double)this.params.distance));
                boolean containedTarget = false;
                for (Player Player2 : players) {
                    Projectile aoe = this.createProjectile(1);
                    aoe.setPos(Projectile3.getX(), Projectile3.getY(), Projectile3.getZ());
                    this.doRangedAttack(aoe, (LivingEntity)Player2);
                    if (Player2 != this.target) continue;
                    containedTarget = true;
                }
                if (!containedTarget) {
                    Projectile aoe = this.createProjectile(1);
                    aoe.setPos(Projectile3.getX(), Projectile3.getY(), Projectile3.getZ());
                    this.doRangedAttack(aoe, this.target);
                }
            } else {
                this.doRangedAttack(Projectile3, this.target);
            }
            if (!this.projectileEntities.isEmpty()) {
                this.attackTime = 10;
                return;
            }
            float relativeAttackDist = (float)(Math.sqrt(distSqr) / (double)this.params.distance);
            this.attackTime = Mth.floor((float)((1.0f + BrutalBosses.rand.nextFloat() * 0.5f) * (relativeAttackDist * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin))) - 5 * this.params.count;
        } else if (this.attackTime < 0) {
            float relativeAttackDist = (float)(Math.sqrt(distSqr) / (double)this.params.distance);
            this.attackTime = Mth.floor((float)((1.0f + BrutalBosses.rand.nextFloat() * 0.5f) * (relativeAttackDist * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin))) - Math.min(5 * this.params.count, this.attackIntervalMin - 5);
        }
    }

    protected abstract Projectile createProjectile();

    protected abstract void doRangedAttack(Projectile var1, LivingEntity var2);

    protected Projectile createProjectile(int number) {
        Projectile Projectile2 = this.createProjectile();
        this.positionProjectile(Projectile2, number);
        Projectile2.noPhysics = true;
        Projectile2.setNoGravity(true);
        Projectile2.setOwner((Entity)this.mob);
        if (Projectile2 instanceof IOnProjectileHit) {
            ((IOnProjectileHit)Projectile2).setMaxLifeTime(this.mob.level().getGameTime() + 1200L);
        }
        this.mob.level().addFreshEntity((Entity)Projectile2);
        return Projectile2;
    }

    protected void positionProjectile(Projectile Projectile2, int number) {
        if (this.params.count == 1) {
            Direction dir = PosUtil.getFacing(this.mob.position(), this.target.position()).getClockWise();
            Projectile2.setPos(this.mob.getX() + (double)dir.getCounterClockWise().getStepX() * 0.5, this.mob.getY() + (double)this.mob.getEyeHeight() - 0.5, this.mob.getZ() + (double)dir.getCounterClockWise().getStepZ() * 0.5);
            return;
        }
        Direction dir = PosUtil.getFacing(this.mob.position(), this.target.position()).getClockWise();
        Vec3 center = new Vec3(this.mob.getX(), this.mob.getY() - 0.5 + (double)(this.mob.getEyeHeight() * this.cap.getBossType().getVisualScale()), this.mob.getZ());
        double y = 0.75 * Math.cos(Math.toRadians(360.0 / (double)(this.params.count + 1) * (double)number));
        double xzRatio = 0.75 * Math.sin(Math.toRadians(360.0 / (double)(this.params.count + 1) * (double)number));
        Vec3 offSet = new Vec3(xzRatio * (double)dir.getStepX(), -y, xzRatio * (double)dir.getStepZ());
        center = center.add(offSet);
        center = center.add(new Vec3((double)dir.getCounterClockWise().getStepX() * 0.5, 0.0, (double)dir.getCounterClockWise().getStepZ() * 0.5));
        Projectile2.setPos(center.x, center.y, center.z);
    }

    public static class RangedParams
    extends IAIParams.DefaultParams {
        protected int count = 1;
        protected int interval = 50;
        protected int distance = 15;
        protected boolean aoe = false;
        protected float speed = 1.0f;
        private static final String PROJECTILE_COUNT = "projectile_count";
        private static final String PROJECTILE_INTERVAL = "projectile_interval";
        private static final String PROJECTILE_DISTANCE = "projectile_distance";
        private static final String PROJECTILE_AOE = "projectile_aoe";
        private static final String PROJECTILE_SPEED = "projectile_speed";

        public RangedParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(PROJECTILE_COUNT)) {
                this.count = jsonElement.get(PROJECTILE_COUNT).getAsInt();
            }
            if (jsonElement.has(PROJECTILE_INTERVAL)) {
                this.interval = jsonElement.get(PROJECTILE_INTERVAL).getAsInt();
            }
            if (jsonElement.has(PROJECTILE_DISTANCE)) {
                this.distance = jsonElement.get(PROJECTILE_DISTANCE).getAsInt();
            }
            if (jsonElement.has(PROJECTILE_AOE)) {
                this.aoe = jsonElement.get(PROJECTILE_AOE).getAsBoolean();
            }
            if (jsonElement.has(PROJECTILE_SPEED)) {
                this.speed = jsonElement.get(PROJECTILE_SPEED).getAsFloat();
            }
            return this;
        }
    }
}

