/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.entity.IOnProjectileHit;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.ai.SimpleRangedAttackGoal;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.phys.EntityHitResult;

public class SnowballAttackGoal
extends SimpleRangedAttackGoal {
    public static final ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:shootsnowballs");
    private static final double AIM_HEIGHT = 2.0;
    private static final double ARROW_SPEED = 1.0;
    private static final double AIM_SLIGHTLY_HIGHER_MULTIPLIER = 0.18;
    private static final double SPEED_FOR_DIST = 35.0;

    public SnowballAttackGoal(Mob mob, IAIParams params) {
        super(mob, params);
    }

    @Override
    protected ResourceLocation getID() {
        return ID;
    }

    @Override
    protected Projectile createProjectile() {
        Snowball snowballentity = new Snowball(this.mob.level(), (LivingEntity)this.mob);
        ((IOnProjectileHit)snowballentity).setMaxLifeTime(this.mob.level().getGameTime() + 800L);
        return snowballentity;
    }

    @Override
    protected void doRangedAttack(Projectile snowballentity, LivingEntity target) {
        snowballentity.noPhysics = false;
        snowballentity.setNoGravity(false);
        this.positionProjectile(snowballentity, 1);
        double xVector = target.getX() - snowballentity.getX();
        double yVector = target.getBoundingBox().minY + (double)target.getBbHeight() / 2.0 - snowballentity.getY();
        double zVector = target.getZ() - snowballentity.getZ();
        double distance = Math.sqrt(xVector * xVector + zVector * zVector);
        double dist3d = Math.sqrt(yVector * yVector + xVector * xVector + zVector * zVector);
        snowballentity.shoot(xVector, yVector + distance * 0.18, zVector, (float)(1.0 + dist3d / 35.0) * this.params.speed, 3.0f);
        this.mob.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.mob.getRandom().nextFloat() * 0.4f + 0.8f));
        if (snowballentity instanceof IOnProjectileHit) {
            ((IOnProjectileHit)snowballentity).setMaxLifeTime(this.mob.level().getGameTime() + 400L);
            ((IOnProjectileHit)snowballentity).setOnHitAction(rayTraceResult -> {
                Entity hitEntity;
                if (rayTraceResult instanceof EntityHitResult && (hitEntity = ((EntityHitResult)rayTraceResult).getEntity()) instanceof LivingEntity) {
                    hitEntity.hurt(this.mob.damageSources().thrown((Entity)snowballentity, (Entity)this.mob), 1.0f);
                    ((LivingEntity)hitEntity).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 4));
                }
            });
        }
    }
}

