/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.BossSpawnHandler;
import com.brutalbosses.entity.ai.IAIParams;
import com.brutalbosses.entity.capability.BossCapEntity;
import com.brutalbosses.entity.capability.BossCapability;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.scores.PlayerTeam;

public class SummonMobsGoal
extends Goal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:summonmobs");
    private final Mob mob;
    private LivingEntity target = null;
    private final SummonParams params;
    private final List<LivingEntity> summonedMobs = new ArrayList<LivingEntity>();
    private int ticksToNextUpdate = 0;

    public SummonMobsGoal(Mob mob, IAIParams params) {
        this.mob = mob;
        this.params = (SummonParams)params;
        PlayerTeam team = mob.level().getScoreboard().getPlayerTeam("bb:bossteam");
        if (team == null) {
            team = mob.level().getScoreboard().addPlayerTeam("bb:bossteam");
        }
        mob.level().getScoreboard().addPlayerToTeam(mob.getScoreboardName(), team);
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        if (target != null && target.isAlive() && this.params.entityIDs.size() > 0) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void start() {
        this.ticksToNextUpdate = Math.max(50, this.ticksToNextUpdate);
    }

    public void stop() {
        this.target = null;
    }

    public void tick() {
        this.summonedMobs.removeIf(summoned -> {
            if (!summoned.isAlive()) {
                if (this.params.ownerdamage > 0.0f && this.mob.getHealth() > this.mob.getMaxHealth() * 0.1f) {
                    this.mob.setHealth(Math.max(this.mob.getMaxHealth() * 0.1f, this.mob.getHealth() - this.mob.getMaxHealth() * this.params.ownerdamage));
                }
                return true;
            }
            return false;
        });
        if (--this.ticksToNextUpdate > 0) {
            if (this.ticksToNextUpdate < 30 && this.mob instanceof SpellcasterIllager) {
                ((SpellcasterIllager)this.mob).setIsCastingSpell(SpellcasterIllager.IllagerSpell.WOLOLO);
            }
            return;
        }
        if (this.mob instanceof SpellcasterIllager) {
            ((SpellcasterIllager)this.mob).setIsCastingSpell(SpellcasterIllager.IllagerSpell.NONE);
        }
        this.ticksToNextUpdate = this.params.interval;
        for (int i = 0; i < this.params.count; ++i) {
            this.trySummonMob();
        }
    }

    private void trySummonMob() {
        LivingEntity summoned;
        if (this.summonedMobs.size() >= this.params.maxcount) {
            return;
        }
        EntityType<? extends LivingEntity> entityType = this.params.entityIDs.get(BrutalBosses.rand.nextInt(this.params.entityIDs.size()));
        try {
            summoned = (LivingEntity)entityType.create(this.mob.level());
            if (this.params.entityNBTData.containsKey(BuiltInRegistries.ENTITY_TYPE.getKey(entityType))) {
                CompoundTag nbt = this.params.entityNBTData.get(BuiltInRegistries.ENTITY_TYPE.getKey(entityType));
                if (nbt.contains("Pos")) {
                    summoned.load(nbt);
                } else {
                    summoned.readAdditionalSaveData(nbt);
                }
                summoned.setUUID(UUID.randomUUID());
            } else if (summoned instanceof RangedAttackMob) {
                summoned.setItemInHand(InteractionHand.MAIN_HAND, Items.BOW.getDefaultInstance());
            }
        }
        catch (Exception e) {
            BossCapability bossCapability = ((BossCapEntity)this.mob).getBossCap();
            if (bossCapability != null) {
                BrutalBosses.LOGGER.warn("Failed summoning add for boss:" + String.valueOf(bossCapability.getBossType().getID()), (Throwable)e);
                return;
            }
            BrutalBosses.LOGGER.warn("Failed summoning add for boss:", (Throwable)e);
            return;
        }
        BlockPos spawnPos = BossSpawnHandler.findSpawnPosForBoss((ServerLevelAccessor)((ServerLevel)this.mob.level()), (Entity)summoned, this.mob.blockPosition());
        if (spawnPos == null) {
            return;
        }
        ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.CLOUD, (double)spawnPos.getX(), (double)(spawnPos.getY() + 1), (double)spawnPos.getZ(), 20, 0.0, 0.0, 0.0, 0.0);
        if (summoned instanceof Mob) {
            PlayerTeam team = this.mob.level().getScoreboard().getPlayerTeam("bb:bossteam");
            if (team == null) {
                team = this.mob.level().getScoreboard().addPlayerTeam("bb:bossteam");
            }
            this.mob.level().getScoreboard().addPlayerToTeam(summoned.getScoreboardName(), team);
            ((Mob)summoned).setTarget(this.target);
        }
        summoned.setPos((double)spawnPos.getX(), (double)spawnPos.getY(), (double)spawnPos.getZ());
        this.mob.level().addFreshEntity((Entity)summoned);
        this.summonedMobs.add(summoned);
    }

    public static class SummonParams
    extends IAIParams.DefaultParams {
        private int interval = 500;
        private List<EntityType<? extends LivingEntity>> entityIDs = new ArrayList<EntityType<? extends LivingEntity>>();
        private int count = 1;
        private int maxcount = 2;
        private float ownerdamage = 0.0f;
        private Map<ResourceLocation, CompoundTag> entityNBTData = new HashMap<ResourceLocation, CompoundTag>();
        private static final String SUMM_INTERVAL = "interval";
        private static final String SUMM_MAX = "maxcount";
        private static final String SUMM_COUNT = "count";
        private static final String ENTITY_ID = "entityid";
        private static final String ENTITIES = "entities";
        private static final String OWNERDAMAGE = "ownerdamagepct";
        private static final String SUMM_ENTITY_NBT = "entitynbt";

        public SummonParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            HashMap<ResourceLocation, CompoundTag> entityData = new HashMap<ResourceLocation, CompoundTag>();
            ArrayList<EntityType<? extends LivingEntity>> types = new ArrayList<EntityType<? extends LivingEntity>>();
            for (JsonElement entityEntry : jsonElement.get(ENTITIES).getAsJsonArray()) {
                ResourceLocation entityID = ResourceLocation.tryParse((String)((JsonObject)entityEntry).get(ENTITY_ID).getAsString());
                types.add((EntityType<? extends LivingEntity>)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityID)));
                if (!((JsonObject)entityEntry).has(SUMM_ENTITY_NBT)) continue;
                try {
                    entityData.put(entityID, TagParser.parseTag((String)((JsonObject)entityEntry).get(SUMM_ENTITY_NBT).getAsString()));
                }
                catch (CommandSyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            this.entityIDs = types;
            this.entityNBTData = entityData;
            if (jsonElement.has(SUMM_INTERVAL)) {
                this.interval = jsonElement.get(SUMM_INTERVAL).getAsInt();
            }
            if (jsonElement.has(SUMM_COUNT)) {
                this.count = jsonElement.get(SUMM_COUNT).getAsInt();
            }
            if (jsonElement.has(SUMM_MAX)) {
                this.maxcount = jsonElement.get(SUMM_MAX).getAsInt();
            }
            if (jsonElement.has(OWNERDAMAGE)) {
                this.ownerdamage = jsonElement.get(OWNERDAMAGE).getAsFloat() / 100.0f;
            }
            return this;
        }
    }
}

