/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class WhirlWind
extends Goal {
    public static ResourceLocation ID = ResourceLocation.tryParse((String)"brutalbosses:whirlwind");
    private final Mob mob;
    private LivingEntity target = null;
    private WhirldWindParams params;
    private int attackTimer = 0;

    public WhirlWind(Mob mob, IAIParams params) {
        this.params = (WhirldWindParams)params;
        this.mob = mob;
    }

    public boolean canUse() {
        LivingEntity target = this.mob.getTarget();
        if (target != null && target.isAlive()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void stop() {
        this.target = null;
        this.attackTimer = 0;
    }

    public void tick() {
        if (--this.attackTimer > 0) {
            return;
        }
        double distSqr = this.mob.distanceToSqr(this.target.getX(), this.target.getY(), this.target.getZ());
        if (distSqr < (double)(this.params.attackDistance * this.params.attackDistance) && BrutalBosses.rand.nextInt(40) == 0) {
            this.attackTimer = this.params.cooldown;
            ArrayList<LivingEntity> entities = new ArrayList<LivingEntity>(this.mob.level().getEntitiesOfClass(Player.class, this.mob.getBoundingBox().inflate(2.0, 0.5, 2.0)));
            if (!entities.contains(this.target)) {
                entities.add(this.target);
            }
            for (LivingEntity livingentity : entities) {
                if (livingentity == this.mob || livingentity == null || !livingentity.isAlive()) continue;
                if (this.params.knockup) {
                    livingentity.setDeltaMovement(livingentity.getDeltaMovement().add(0.0, (double)(this.params.knockback / 5.0f), 0.0));
                } else {
                    livingentity.knockback((double)this.params.knockback, (double)Mth.sin((float)(livingentity.getYRot() * (float)Math.PI)), (double)(-Mth.cos((float)(livingentity.getYRot() * (float)Math.PI))));
                }
                this.mob.swing(InteractionHand.MAIN_HAND);
                float damage = this.params.extraDamage;
                if (this.mob.getAttributes().hasAttribute(Attributes.ATTACK_DAMAGE)) {
                    damage = (float)((double)damage + this.mob.getAttributeValue(Attributes.ATTACK_DAMAGE));
                }
                livingentity.hurt(this.mob.damageSources().mobAttack((LivingEntity)this.mob), damage);
                if (this.params.onHitMobEffect == null) continue;
                livingentity.addEffect(new MobEffectInstance(this.params.onHitMobEffect, this.params.potionduration, this.params.potionlevel));
            }
            this.mob.level().playSound(null, this.mob.getX(), this.mob.getY(), this.mob.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, this.mob.getSoundSource(), 1.0f, 1.0f);
            double d0 = -Mth.sin((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            double d1 = Mth.cos((float)(this.mob.getYRot() * ((float)Math.PI / 180)));
            if (this.mob.level() instanceof ServerLevel) {
                ((ServerLevel)this.mob.level()).sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, this.mob.getX() + d0, this.mob.getY(0.5), this.mob.getZ() + d1, 2, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static class WhirldWindParams
    extends IAIParams.DefaultParams {
        private float attackDistance = 4.0f;
        private float extraDamage = 2.0f;
        private Holder<MobEffect> onHitMobEffect = null;
        private float knockback = 4.0f;
        private int cooldown = 80;
        private int potionlevel = 1;
        private int potionduration = 60;
        private boolean knockup = false;
        private static final String ATKDIST = "attackdist";
        private static final String EXTDMG = "extradamage";
        private static final String POTION = "potiononhit";
        private static final String POTION_STR = "potionlevel";
        private static final String POTION_DUR = "potionduration";
        private static final String KNOCK = "knockback";
        private static final String COOLDOWN = "cooldown";
        private static final String KNOCK_UP = "knockup";

        public WhirldWindParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(ATKDIST)) {
                this.attackDistance = jsonElement.get(ATKDIST).getAsFloat();
                this.attackDistance *= this.attackDistance;
            }
            if (jsonElement.has(EXTDMG)) {
                this.extraDamage = jsonElement.get(EXTDMG).getAsFloat();
            }
            if (jsonElement.has(POTION_STR)) {
                this.potionlevel = jsonElement.get(POTION_STR).getAsInt();
            }
            if (jsonElement.has(POTION_DUR)) {
                this.potionduration = jsonElement.get(POTION_DUR).getAsInt();
            }
            if (jsonElement.has(COOLDOWN)) {
                this.cooldown = jsonElement.get(COOLDOWN).getAsInt();
            }
            if (jsonElement.has(KNOCK)) {
                this.knockback = jsonElement.get(KNOCK).getAsFloat();
            }
            if (jsonElement.has(KNOCK_UP)) {
                this.knockup = jsonElement.get(KNOCK_UP).getAsBoolean();
            }
            if (jsonElement.has(POTION)) {
                ResourceLocation MobEffectID = ResourceLocation.tryParse((String)jsonElement.get(POTION).getAsString());
                this.onHitMobEffect = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(MobEffectID).get();
            }
            return this;
        }
    }
}

