/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.thrownentity;

import com.brutalbosses.entity.ModEntities;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class ThrownItemEntity
extends ThrowableItemProjectile {
    public static ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"brutalbosses", (String)"thrownitem");
    private static EntityDataAccessor<Float> DATA_VSSCALE = SynchedEntityData.defineId(ThrownItemEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private float scale = 1.0f;

    public ThrownItemEntity(EntityType<ThrownItemEntity> type, Level world) {
        super(type, world);
        this.noCulling = true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_VSSCALE, (Object)Float.valueOf(1.0f));
        super.defineSynchedData(builder);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataParameter) {
        super.onSyncedDataUpdated(dataParameter);
        if (dataParameter == DATA_VSSCALE) {
            this.scale = ((Float)this.getEntityData().get(DATA_VSSCALE)).floatValue();
        }
    }

    public ThrownItemEntity(Level level, Mob mob) {
        super(ModEntities.THROWN_ITEMC, (LivingEntity)mob, level);
        this.noCulling = true;
    }

    protected Item getDefaultItem() {
        return Items.ACACIA_DOOR;
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.dimensions = ModEntities.THROWN_ITEMC.getDimensions().scale(scale);
        this.getEntityData().set(DATA_VSSCALE, (Object)Float.valueOf(scale));
    }
}

